#define DEBUG 1
#include <stdio.h>
#include <string.h>
#include <Bitmap.h>
#include <Button.h>
#include <app/Application.h>
#include <support/Debug.h>
#include "BTSChatWindow.h"
#include "BTSChatConstants.h"
#include "BTSBorderTextView.h"

BRect chatWindowRect(100,200,300,400);
BRect chatNameRect(10, 10, 190, 30);
BRect chatMessageRect(10, 40, 190, 150);
BRect chatOutMessageRect(10, 160, 150, 190);
BRect sendButtonRect(160, 160, 190, 190);

// =============================================================================
//     BTSChatWindow
// =============================================================================
BTSChatWindow::BTSChatWindow(char* inName) : BWindow(chatWindowRect, inName, 
								B_TITLED_WINDOW,  B_NOT_RESIZABLE)
{
	Lock();
	BRect textRect = chatOutMessageRect;
	textRect.left +=1;
	textRect.right -= 1;
	textRect.top  += 1;
	textRect.bottom  -=1;
	
	// Create and add the children.
	fChatName = new BTextControl(chatNameRect, "chat name", "Name: ",
						NULL, NULL);

	fOutMessage = new BTSBorderTextView(chatOutMessageRect, "chat out message",
						textRect, B_FULL_UPDATE_ON_RESIZE, 
						B_FOLLOW_ALL_SIDES|B_WILL_DRAW);
	
	fMessages = new BTSBorderTextView(chatMessageRect, "messages", chatMessageRect,
					B_FULL_UPDATE_ON_RESIZE, B_FOLLOW_ALL_SIDES|B_WILL_DRAW);
					
	fMessages->MakeEditable(false);
	fSendButton = new BButton(sendButtonRect, "Send Button", "Send", 
								new BMessage(SEND_CHAT_MSG));
	
	AddChild(fChatName);
	AddChild(fMessages);
	AddChild(fOutMessage);
	AddChild(fSendButton);

	fOutMessage->SetMaxBytes(255);
	fSendButton->MakeDefault(true);
	fMessages->SetWordWrap(true);
	fOutMessage->SetWordWrap(true);
	Unlock();

	return;
}
	
void BTSChatWindow::Draw()
{
	fOutMessage->StrokeRect(chatOutMessageRect);
	fMessages->StrokeRect(chatMessageRect);
	return;
}
	
// =============================================================================
//     QuitRequested
// =============================================================================
bool	
BTSChatWindow::QuitRequested()
{
	// Tell the application to quit!
	be_app->PostMessage(B_QUIT_REQUESTED);
	return(TRUE);
}

// =============================================================================
//     MessageReceived
// =============================================================================
void 
BTSChatWindow::MessageReceived(BMessage* inMessage)
{
	PRINT(("BTSChatWindow::MessageReceived - ENTER\n"));
	switch (inMessage->what)
	{
		case SEND_CHAT_MSG:
		{
			fOutMessage->Invalidate(Bounds());
			if (fOutMessage->TextLength() > 0)
			{
				BMessage* chatMessage = new BMessage(CHAT_MSG);
				const char* nameString = fChatName->Text();
				const char* contentString = fOutMessage->Text();
				chatMessage->AddString(CHAT_NAME, nameString);
				chatMessage->AddString(CHAT_CONTENT, contentString);
				be_app->PostMessage(chatMessage);
				fOutMessage->SetText(NULL);
			}
		}
		case CHAT_MSG:
			PRINT(("CHAT MSG\n"));
			if (inMessage->HasString(CHAT_NAME) && inMessage->HasString(CHAT_CONTENT))
			{
				const char* nameString = inMessage->FindString(CHAT_NAME);
				const char* contentString = inMessage->FindString(CHAT_CONTENT);
				long textLength;
				fMessages->Insert("\n");
				fMessages->Insert(nameString);
				fMessages->Insert(">>>  ");
				fMessages->Insert(contentString);
				textLength = fMessages->TextLength();
				fMessages->Select(textLength, textLength+1);
				fMessages->ScrollToSelection();
			}	
			PRINT(("CHAT MSG END\n"));		
		break;
		
		case QUIT_CHAT_WINDOW_MSG:	
			PRINT(("Window quitting...\n"));
			QuitRequested();
		break;
		
		default:
			BWindow::MessageReceived(inMessage);
		break;				
	}
	PRINT(("BTSChatWindow::MessageReceived - EXIT\n"));
}

// =============================================================================
//     AddChatMessage
// =============================================================================
void 
BTSChatWindow::AddChatMessage(char* name, char* message)
{

}						
