//#define DEBUG 1
// =============================================================================
//     BTSNetDrawClient.cpp
// =============================================================================
// Implements a simple client. Puts up a dialog that allows the user
// to select a host to connect to. Once connected, it displays a 
// window that can be drawn in with the mouse. Drawing commands are
// sent to the server and received from other clients and drawn in
// the window.

#include <stdio.h>
#include <string.h>
#include <AppKit.h>
#include <InterfaceKit.h>
#include <support/Debug.h>

#include "BTSNetDrawWindow.h"
#include "BTSPrefDlog.h"
#include "BTSNetDrawClient.h"
#include "BTSNetDrawMsgDefs.h"

char* kRequestHandlerName = "Request Handler";
char* kNetDrawClientName = "Net Draw Client";

main()
{	
	// The new mantra.
	_setDebugFlag(TRUE);
	BTSNetDrawClient *myApplication;

	myApplication = new BTSNetDrawClient();
	
	myApplication->Run();
	
	delete(myApplication);
	return(0);
}

// =============================================================================
//     BTSNetDrawClient
// =============================================================================
BTSNetDrawClient::BTSNetDrawClient(): BApplication('NTCL')
{	
	fExiting = FALSE;
	fHostName = NULL;
	fDrawWindow = NULL;
	fPrefDlog = NULL;
	fClient = NULL;
	fBitmap = NULL;
	fView = NULL;
	return;
}

// =============================================================================
//     SetHostName
// =============================================================================
void	
BTSNetDrawClient::SetHostName(const char* inName)
{
	fHostName = strdup(inName);
}

// =============================================================================
//     GetHostName
// =============================================================================
char* 	
BTSNetDrawClient::GetHostName()
{
	return fHostName;
}

// =============================================================================
//     QuitRequested
// =============================================================================
bool 	
BTSNetDrawClient::QuitRequested()
{
	PRINT(("App quit requested\n"));
	fExiting = TRUE;
	if (fClient)
	{	
		fClient->Quit();
		fClient = NULL;
	}
	PRINT(("Posting message to window\n"));
	if (fDrawWindow)
	{
		fDrawWindow->PostMessage(QUIT_DRAW_WINDOW_MSG);
	}
	return BApplication::QuitRequested();
}


// =============================================================================
//     MessageReceived
// =============================================================================
void 
BTSNetDrawClient::MessageReceived(BMessage* inMessage)
{
	PRINT(("BTSNetDrawClient::MessageReceived - ENTER\n"));

	switch (inMessage->what)
	{
		case QUIT_DRAW_WINDOW_MSG:
			// Quit requested from draw window.
			fExiting = TRUE;
			PostMessage(B_QUIT_REQUESTED);
		break;
		
		case PREFS_ACCEPTED_MSG:
			// User has clicked "OK" in preference dialog.
			const char* hostName;
			if (inMessage->FindString(HOST_NAME, &hostName) == B_NO_ERROR)
			{
				SetHostName(hostName);
				fClient = new BTSNetMsgClient(kNETDRAWPORT, fHostName);
				if (!fClient->Run())
				{
					PostMessage(B_QUIT_REQUESTED);
				}
				else
				{
					// Client has managed to connect to the server.
					BRect drawWindowRect(100,200,300,400);
					fDrawWindow = new BTSNetDrawWindow(drawWindowRect, 
										kNetDrawClientName);
					fDrawWindow->Show();
					fPrefDlog->Close();
				}
			}
		break;
				
		case CLEAR_MSG:
		case NETDRAWLINE_MSG:
		case BITMAP_DATA_MSG:
			// Drawing messages for window. If they're generated 
			// locally, send them to the server.
			PRINT(("Got message for window\n"));
			
			if (!fExiting)
			{
				fDrawWindow->PostMessage(inMessage);
				if (!(inMessage->HasPointer(SOURCE_SOCKET)) && !(fClient->IsExiting()))
				{
					//It's a locally-generated message.
					PRINT(("Sending local message out\n"));
					fClient->PostMessage(inMessage);
				}
			}
		break;
			
		case DEAD_CONNECTION_MSG:
			// Client connection has died. Just exit.
			PostMessage(B_QUIT_REQUESTED);
		break;
		
		default:
			BApplication::MessageReceived(inMessage);
		break;
	}
	PRINT(("BTSNetDrawClient::MessageReceived - EXIT\n"));
	return;
}


// =============================================================================
//     ReadyToRun
// =============================================================================
void 
BTSNetDrawClient::ReadyToRun()
{
	// Create the dialog.
	fPrefDlog = new BTSPrefDlog();
	fPrefDlog->Show();
	return;
}


