// =============================================================================
//     BTSSocket.h
// =============================================================================
/*	Implementation of a socket object. Socket is not server/client specific,
	only does tcp/ip right now. */
#ifndef _B_BTSSOCKET_
#define _B_BTSSOCKET_

#include <kernel/OS.h>
#include "BTSAddress.h"

// =============================================================================
class BTSSocket
{
	public:
						BTSSocket();
						BTSSocket(const int type, const int protocol , 
									const int family = AF_INET );
						BTSSocket(const int socketID);
		virtual long	SetOption(const int level, const int option,
									char* data, 
									const unsigned int size) const;
		virtual long	ConnectToAddress(const BTSAddress& address);
		virtual long	BindTo(const BTSAddress& address) const;
		virtual	long	Send(const char* buf, const long bufSize) const;
		virtual	long	Recv(const char* buf, const long bufSize) const;
		virtual long 	Open();	
		virtual long	Listen(const int maxConnections);
		virtual long	Close();
		virtual int		ID() {return fID;}const;
		
		virtual long	SendLock() const;
		virtual long	SendUnlock() const;
		virtual long	RecvLock() const;
		virtual long	RecvUnlock() const;
		
	private:
		
		int				fID;
		const int		fFamily;
		int				fType;
		int				fProtocol;
		int 			fMaxConnections;
		
		sem_id			fSendSem;
		sem_id			fRecvSem;
		
		virtual void	Init();
		static void		UpdateSendCount(const long numBytes);
		static void		UpdateReceiveCount(const long numBytes);
};


#endif