// =============================================================================
//     BTSAddress.cpp
// =============================================================================

#include <string.h>
#include <netdb.h>
#include "BTSAddress.h"


// =============================================================================
//     BTSAddress
// =============================================================================
BTSAddress::BTSAddress(const int family, const unsigned long port, 
						const unsigned long address)
{
	// Define the connection information.
	fAddr.sin_family = family;
	fAddr.sin_port = htonl(port);	//htonl gives portability.
	fAddr.sin_addr.s_addr = address;
	::memset(fAddr.sin_zero, 0, sizeof(fAddr.sin_zero));
	fHostName = NULL;
	return;
}

// =============================================================================
//     BTSAddress
// =============================================================================
BTSAddress::BTSAddress(const int family, const unsigned long port, 
						const char* hostName)
{
	// Define the connection information.
	struct hostent* host = gethostbyname(hostName);
	fAddr.sin_addr.s_addr = *(unsigned long*)(host->h_addr);
	fAddr.sin_family = family;
	fAddr.sin_port = htonl(port);	//htonl gives portability.
	::memset(fAddr.sin_zero, 0, sizeof(fAddr.sin_zero));
	fHostName = hostName;
	
	return;
}

// =============================================================================
//     SockAddr
// =============================================================================
const sockaddr_in*	
BTSAddress::SockAddr() const
{
	return &fAddr;
}

// =============================================================================
//     HostEntry
// =============================================================================
hostent*	
BTSAddress::HostEntry() const
{
	struct hostent* entry = NULL;
	if (fHostName != NULL)
	{
		entry = ::gethostbyname(fHostName);	// Convert host name to ip addr

	}
	else if (fAddr.sin_addr.s_addr != 0)
	{
		//entry = gethostbyaddr(fAddr.sin_addr.s_addr);
	}
	return entry;
}