//--------------------------------------------------------------------
//	
//	Status.h
//
//	Written by: Robert Polic
//	
//	Copyright 1997 Be, Inc. All Rights Reserved.
//	
//--------------------------------------------------------------------

#pragma once
#ifndef STATUS_H
#define STATUS_H

#include <Beep.h>
#include <Box.h>
#include <Button.h>
#include <TextControl.h>
#include <Window.h>

#define	STATUS_WIDTH		200
#define STATUS_HEIGHT		 70

#define STATUS_TEXT			"Status:"
#define STATUS_FIELD_H		  8
#define STATUS_FIELD_V		  8
#define STATUS_FIELD_WIDTH	(STATUS_WIDTH - 8)
#define STATUS_FIELD_HEIGHT	 16

#define BUTTON_WIDTH		 70
#define BUTTON_HEIGHT		 20
#define OK_BUTTON_TEXT		"OK"
#define OK_BUTTON_H			 15
#define OK_BUTTON_V			(STATUS_HEIGHT - BUTTON_HEIGHT - 12)

#define CANCEL_BUTTON_TEXT	"Cancel"
#define CANCEL_BUTTON_H		(STATUS_WIDTH - BUTTON_WIDTH - OK_BUTTON_H)
#define CANCEL_BUTTON_V		OK_BUTTON_V

enum	status_messages		{STATUS = 128, OK, CANCEL};

class	TStatusView;


//====================================================================

class TStatusWindow : public BWindow {

private:

TStatusView		*fView;

public:

				TStatusWindow(BRect, BWindow*, char*);
};

//--------------------------------------------------------------------

class TStatusView : public BBox {

private:

char			*fString;
BTextControl	*fStatus;
BWindow			*fWindow;

public:

				TStatusView(BRect, BWindow*, char*); 
virtual	void	AttachedToWindow(void);
virtual void	MessageReceived(BMessage*);
};
#endif
