#include "ListWindow.h"

AxeList::AxeList(BRect rect, char *name) : BListView(rect, name)
{
	current_selection = -1;
}

void AxeList::SelectionChanged(void)
{
	int32 selection;
	selection = CurrentSelection();

	if (this == ((ListWindow *)Window())->group_view)
		((ListWindow *)Window())->SelectGroup(selection);

	if (current_selection != -1)
		InvalidateItem(current_selection);

	InvalidateItem(current_selection = selection);
	ScrollToSelection();
}

AxeItem::AxeItem(axe_thing *t)
{
	thing = t;
}

void AxeItem::DrawItem(BView *owner,
							BRect bounds,
							bool complete)
{
	if (IsSelected()) {
		owner->SetHighColor(HighItemColor);
		owner->FillRect(bounds);
	}
	else {
		owner->SetHighColor(255,255,255);
		owner->FillRect(bounds);
	}
	owner->SetHighColor(0,0,0);
	owner->MovePenTo(bounds.left+4, bounds.bottom-2);
	owner->DrawString(thing->string);
}

GroupItem::GroupItem(axe_list *t) 
{
	thing = t;
}

void GroupItem::DrawItem(BView *owner,
							BRect bounds,
							bool complete)
{
	BRect b;
	if (IsSelected()) {
		owner->SetHighColor(HighItemColor);
		owner->FillRect(bounds);
	}
	else {
		owner->SetHighColor(255,255,255);
		owner->FillRect(bounds);
	}
	b = bounds;
	b.InsetBy(2,2);
	b.right = b.left + (b.bottom-b.top);
	owner->SetHighColor(thing->color);
	owner->FillRect(b, B_SOLID_HIGH);
	owner->SetHighColor(0,0,0);
	owner->MovePenTo(bounds.left+(b.bottom-b.top)+6, bounds.bottom-3);
	owner->DrawString(thing->string);
}

#define LEFT_OFF (W_W+7)
#define TOP_OFF -4
#define TOP_STEAL 48
ListWindow::ListWindow(BPoint where):
	BWindow(BRect(where.x+LEFT_OFF, where.y+TOP_OFF, 
		where.x+LEFT_OFF+L_W, where.y+TOP_OFF+L_H), "axe lists",
	B_BORDERED_WINDOW, B_NOT_RESIZABLE|B_NOT_ZOOMABLE|
	B_WILL_ACCEPT_FIRST_CLICK)
{
	GroupItem *items[AXE_LIST_COUNT];
	axe_list *axe_list_ptr;
	AxeItem ***axes;
	int32 ktr, aktr;
	BRect b = Bounds();	

	background = new BView(b, "background", B_FOLLOW_ALL,
		B_WILL_DRAW);
	background->SetViewColor(BackgroundColor);
	AddChild(background);

	group_view = new AxeList(BRect(2, 2, 
		b.right-2, ((b.bottom/2)-3)+TOP_STEAL), "axe list view");
	background->AddChild(group_view);
	axes = (AxeItem ***)malloc(sizeof(AxeItem **)* AXE_LIST_COUNT);

	for (ktr = 0; ktr < AXE_LIST_COUNT; ktr++) {
		axe_list_ptr = &axe_lists[ktr];
		axe_list_ptr->color.red = ((RED_SCALE*ktr)+RED_OFF)%255;
		axe_list_ptr->color.green = 10;//((GREEN_SCALE*ktr)+GREEN_OFF)%255;
		axe_list_ptr->color.blue = ((BLUE_SCALE*ktr)+BLUE_OFF)%255;
		items[ktr] = new GroupItem(axe_list_ptr);
		group_view->AddItem(items[ktr]);
	
		axe_view[ktr] = new AxeList(BRect(2, (b.bottom/2)+TOP_STEAL, 
			b.right-2, b.bottom-2), "axe view");

		axes[ktr] = (AxeItem **)malloc(sizeof(AxeItem*)*axe_list_ptr->count);

		for (aktr = 0; aktr < axe_list_ptr->count; aktr++) {
			axes[ktr][aktr] = new AxeItem(&axe_list_ptr->list[aktr]);
			axe_view[ktr]->AddItem(axes[ktr][aktr]);
		}

		background->AddChild(axe_view[ktr]);
		axe_view[ktr]->Hide();
	}
	current_group = -1;	
	SelectGroup(0);
}

void ListWindow::Move(BPoint where)
{
	MoveTo(where.x+LEFT_OFF, where.y+TOP_OFF);
}
midi_axe ListWindow::CurrentAxe()
{
	int32 sel = axe_view[current_group]->CurrentSelection();
	midi_axe axe;
	if (sel >= 0) {
		axe = ((AxeItem *)axe_view[current_group]->ItemAt(sel))->thing->num;
		return axe;
	}
	else
		return (midi_axe)128;
}

void ListWindow::SelectGroup(int32 which)
{
	if (current_group != -1)
		axe_view[current_group]->Hide();
	axe_view[which]->Show();
	current_group = which;
}

rgb_color ListWindow::CurrentColor()
{
	return ((GroupItem *)group_view->ItemAt(current_group))->thing->color;
}

