#include "BoardView.h"
#include "AxeApp.h"
#include "ListWindow.h"

static rgb_color DeadColor;
rgb_color invert_color(rgb_color color);

Note::Note()
{
	next = NULL;
	prev = NULL;
}

int32 _blipper(void *arg);
int32 _blipper(void *arg)
{
	while (((BoardView *)arg)->go) {
		snooze(20000);
		((BoardView *)arg)->Blip();
	}
	return 1234;
}


BoardView::BoardView(float voff):
BView(BRect(0,voff, (V_Q_W*2), (V_Q_H*2)+voff), "axev", 0,
	B_WILL_DRAW)
{
	int ktr;
	BRect b = Bounds();
	arm = (b.right-b.left)/2.0;
	center.Set(arm,arm);
	arm -= ARM_INSET;

	blip_arc = NO_BLIP;
	blipper = spawn_thread(_blipper, "blipper", 
		B_REAL_TIME_DISPLAY_PRIORITY,
		(void *)this);
	NewDeadColor();
	dead_down = false;
	nm_ktr = 0;
	
	bit_view = NULL;
	bmap = new BBitmap(b, B_RGB_32_BIT, true);
	FillBitmap();
	shelf = new BShelf(this);
	StartBlipper();
}

void BoardView::NewDeadColor()
{
	DeadColor.red = rand() % 255;
	DeadColor.blue = rand() % 255;
	DeadColor.green = rand() %255;
	nm_max = max_c(max_c(DeadColor.red, DeadColor.green), DeadColor.blue);
}

BoardView::StopBlipper()
{
	int32 status;

	go = false;
	wait_for_thread(blipper, &status);
}

BoardView::StartBlipper()
{
	go = true;
	start_time = system_time();
	resume_thread(blipper);
}

bool within(float dot, float arca, float arcb); 
bool within(float dot, float arca, float arcb) 
{
	return (((arca > arcb) && (dot < arca && dot >= arcb)) ||
		 ((arcb > arca) && (dot < arca || dot >= arcb)));
}
#define DIA 35
#define DIV 4
void BoardView::Blip()
{
	float stime = system_time();
	float now = stime - start_time;
	float angle;
	float prev_arc;
	rgb_color this_color;
	Note *kill;
	int32 ktr;
	BRect b;
	Note *note;
	float spark = 0.0;

	Window()->Lock();
	
	if (blip_arc != NO_BLIP) {
		b.Set(blip.x-BLIP_SIZE, blip.y-BLIP_SIZE, 
			blip.x+BLIP_SIZE, blip.y+BLIP_SIZE);
		SetHighColor(TrackColor);
		FillEllipse(b, B_SOLID_HIGH);
	}

	prev_arc = blip_arc;	
	angle = (now/1000000)*RATE;

	blip.x = sin(angle)*(arm+BLIP_SIZE);
	blip.y = cos(angle)*(arm+BLIP_SIZE);
	blip_arc = atan2(blip.x, blip.y)*-1;
	blip.x = center.x-blip.x;
	blip.y += center.y;
	
	SetHighColor(BlipColor);
	FillEllipse(blip, BLIP_SIZE, BLIP_SIZE, B_SOLID_HIGH);	

	SetHighColor(NoteColor);
	SetLowColor(NoteOnColor);

	for (note = notes; note != NULL; note = note->next) {
		if (note->killMe) {
			if (note->next)
				note->next->prev = note->prev;
			if (note->prev)
				note->prev->next = note->next;
			if (note == last_note) 
				last_note = note->prev;
			if (note == notes) 
				notes = note->next;

			if (note->isOn) 
				((AxeApp *)be_app)->synth->NoteOff(1, note->pitch, 0);

			SetHighColor(FieldColor);
			StrokeEllipse(note->area, B_SOLID_HIGH);
			kill = note;
			note = note->next;
			delete kill;

			if (!note) break;
		}
		if (prev_arc != NO_BLIP) {
			if (note->isLit) {
				note->isLit = false;
				SetHighColor(note->color);
				StrokeEllipse(note->area, B_SOLID_HIGH);
			}
			if ((note->isOn) && ((stime - note->onTime) > MAX_DUR)) {
					((AxeApp *)be_app)->synth->NoteOff(1, note->pitch, 0);
					note->isOn = false;
			}
		}
		if (within(note->arc, prev_arc, blip_arc)) {
			((AxeApp *)be_app)->synth->ProgramChange(1, note->axe);
			((AxeApp *)be_app)->synth->NoteOn(1, note->pitch, 100);
			StrokeEllipse(note->area, B_SOLID_LOW);
			note->isLit = true;
			note->isOn = true;
			note->onTime = stime;
			spark += .6;
		}
	}
	if (dead_down) {
		b = Bounds();

		this_color.red = max_c(0, DeadColor.red - nm_ktr);
		this_color.green = max_c(0, DeadColor.green - nm_ktr);
		this_color.blue = max_c(0, DeadColor.blue - nm_ktr);
		SetLowColor(this_color);

		FillArc(BPoint(DIA,DIA), nm_ktr/DIV, DIA-nm_ktr/DIV, nm_ktr, -90, B_SOLID_LOW);
		FillArc(BPoint(b.right-DIA,DIA), nm_ktr/DIV, DIA-nm_ktr/DIV, nm_ktr, -90, B_SOLID_LOW);
		FillArc(BPoint(b.right-DIA,b.bottom-DIA), nm_ktr/DIV, DIA-nm_ktr/DIV, nm_ktr, -90, B_SOLID_LOW);
		FillArc(BPoint(DIA,b.bottom-DIA), nm_ktr/DIV, DIA-nm_ktr/DIV, nm_ktr, -90, B_SOLID_LOW);

		b.InsetBy(128+ARM_INSET,128+ARM_INSET);
		b.InsetBy((b.right-b.left)/8, (b.bottom-b.top)/8);
		SetPenSize((b.right-b.left)/4);
		StrokeEllipse(b, B_SOLID_LOW);
		SetHighColor(invert_color(this_color));
		b.InsetBy(((b.right-b.left)/8)+3,((b.bottom-b.top)/8)+3);
		FillEllipse(b, B_SOLID_HIGH);
		
		if (nm_ktr++ == nm_max) {
			nm_ktr = 0;
			NewDeadColor();
			dead_down = false;
		}
	}
	else {
		b = Bounds();
		this_color.red = min_c(DeadColor.red,nm_ktr);
		this_color.green = min_c(DeadColor.green,nm_ktr);
		this_color.blue = min_c(DeadColor.blue, nm_ktr);
		SetLowColor(this_color);
		SetHighColor(invert_color(this_color));
		FillArc(BPoint(DIA,DIA), DIA-nm_ktr/DIV, nm_ktr/DIV, nm_ktr, 90, B_SOLID_HIGH);
		FillArc(BPoint(b.right-DIA,DIA), DIA-nm_ktr/DIV, nm_ktr/DIV, nm_ktr, 90, 
			B_SOLID_HIGH);
		FillArc(BPoint(b.right-DIA,b.bottom-DIA), DIA-nm_ktr/DIV, nm_ktr/DIV, 
			nm_ktr, 90, B_SOLID_HIGH);
		FillArc(BPoint(DIA,b.bottom-DIA), DIA-nm_ktr/DIV, nm_ktr/DIV, nm_ktr, 90, 
			B_SOLID_HIGH);

		b.InsetBy(128+ARM_INSET,128+ARM_INSET);
		b.InsetBy((b.right-b.left)/8, (b.bottom-b.top)/8);
		SetPenSize((b.right-b.left)/4.0);
		StrokeEllipse(b, B_SOLID_LOW);
		b.InsetBy(((b.right-b.left)/8)+3,((b.bottom-b.top)/8)+3);
		FillEllipse(b, B_SOLID_HIGH);
		if (nm_ktr++ == nm_max) {
			nm_ktr = 0;
			dead_down = true;
		}

	}
	if (spark > 0.0) {
		b.InsetBy(((b.right-b.left)/2)-spark*2,
					((b.bottom-b.top)/2)-spark*2);
		FillEllipse(b, B_SOLID_LOW);
	}

	SetPenSize(1);
	Window()->Unlock();
}

void BoardView::AttachedToWindow()
{
	MakeFocus();
}

rgb_color invert_color(rgb_color color)
{
	rgb_color new_color;
	new_color.red = 255-color.red;
	new_color.green =255-color.green;
	new_color.blue = 255-color.blue;
	return new_color;
}

void BoardView::FillBitmap()
{
	int xktr, yktr, bktr;
	uchar *bits, *bptr;
	int32 length;
	BRect bounds, track, field, circle;
	BPoint center;
	float cx, cy, ex, ey, px, py;

	bmap->Lock();
	bounds = bmap->Bounds();

	track = bounds;
	track.InsetBy(ARM_INSET-(BLIP_SIZE+2),ARM_INSET-(BLIP_SIZE+2));

	field = track;
	field.InsetBy(BLIP_SIZE+4,BLIP_SIZE+4);
	
	circle = field;
	circle.InsetBy(128, 128);
	center.x = cx = bounds.right/2;
	center.y = cy = bounds.bottom/2;

	if (!bit_view) {
		bit_view = new BView(bounds, "bit view", 0, B_WILL_DRAW);
		bmap->AddChild(bit_view);
	}

	/* Draw the background. */
	length = (bounds.right+1)*(bounds.bottom+1)*3;
	bptr= bits = (uchar *)malloc(length);

	for (yktr = 0; yktr <= bounds.bottom; yktr++) 
		for (xktr = 0; xktr <= bounds.right; xktr++) {
				*bptr++ = rand() % 255;
				*bptr++ = 0;
				*bptr++ = rand() % 255;
	}
	bmap->SetBits((void *)bits, length, 0, B_RGB_32_BIT);

	/*Draw the track and field. */
	bit_view->SetLowColor(TrackColor);
	bit_view->FillEllipse(track, B_SOLID_LOW);

	bit_view->SetLowColor(FieldColor);
	bit_view->FillEllipse(field, B_SOLID_LOW);

	/* Draw the hashes. */
	px = (field.right - cx)*.95;
	py = (field.bottom - cy)*.95;

	ex = px;
	ey = py;

	bit_view->SetHighColor(EightColor);
	bit_view->SetPenSize(1.0);
	bit_view->StrokeLine(center, BPoint(cx, cy - ey), B_SOLID_HIGH);
	bit_view->StrokeLine(center, BPoint(cx, cy + ey), B_SOLID_HIGH);
	bit_view->StrokeLine(center, BPoint(cx - ex, cy), B_SOLID_HIGH);
	bit_view->StrokeLine(center, BPoint(cx + ex, cy), B_SOLID_HIGH);
	
	ex *= .71;
	ey *= .71;
	bit_view->StrokeLine(center, BPoint(cx + ex, cy - ey), B_SOLID_HIGH);
	bit_view->StrokeLine(center, BPoint(cx + ex, cy + ey), B_SOLID_HIGH);
	bit_view->StrokeLine(center, BPoint(cx - ex, cy - ey), B_SOLID_HIGH);
	bit_view->StrokeLine(center, BPoint(cx - ex, cy + ey), B_SOLID_HIGH);
	ex = px * .89;
	ey = (py * .89)/2;
	bit_view->SetHighColor(SixColor);
	bit_view->StrokeLine(center, BPoint(cx - ex, cy - ey), B_SOLID_HIGH);
	bit_view->StrokeLine(center, BPoint(cx - ex, cy + ey), B_SOLID_HIGH);
	bit_view->StrokeLine(center, BPoint(cx + ex, cy - ey), B_SOLID_HIGH);
	bit_view->StrokeLine(center, BPoint(cx + ex, cy + ey), B_SOLID_HIGH);

	/* Draw the inner circle */
	bit_view->SetLowColor(TrackColor);
	bit_view->FillEllipse(circle, B_SOLID_LOW);

	/* Draw the octave rings */
	circle.InsetBy(-48, -48);

	bit_view->SetHighColor(DeadColor);
	bit_view->SetPenSize(2);
	bit_view->StrokeEllipse(circle, B_SOLID_HIGH);
	
	circle.InsetBy(-24, -24);
	bit_view->StrokeEllipse(circle, B_SOLID_HIGH);
	bit_view->Sync();
	bmap->Unlock();

	free(bits);

}
			

void BoardView::Draw(BRect update)
{
	BRect b = Bounds();
	int32 ktr;
	Note *note;

	SetLowColor(BackgroundColor);
	FillEllipse(b, B_SOLID_LOW);
	DrawBitmap(bmap);
	
	SetHighColor(NoteColor);
	SetPenSize(1.0);
	for (note = notes; note; note = note->next) 
		StrokeEllipse(note->area, B_SOLID_HIGH);
}

void BoardView::KeyDown(const char *bytes, int32 numBytes)
{
	int32 ktr;
	Note *note;

	for (note = notes; note != NULL; note = note->next) {
		delete note;
	}
 	notes = last_note = NULL;
	
 	((AxeApp *)be_app)->synth->AllNotesOff(false);
 	Invalidate();
}

void BoardView::MouseDown(BPoint where)
{
	int32 ktr;
	float length;
	BPoint new_where;
	Note *note, *erasedNote = NULL;
	midi_axe axe;
	
	Window()->Lock();
	//if (!Window()->IsActive())
	//	Window()->Activate();
	for (note = notes; note; note = note->next) {
		if ((!note->killMe) && note->area.Contains(where)) {
			note->killMe = true;
			Window()->Unlock();
			return;
		}
	}

	Window()->Unlock();	
	new_where.Set(where.x-center.x, where.y-center.y);

	axe =((AxeApp *)be_app)->lwindow->CurrentAxe();
	length = (float)pow((new_where.x * new_where.x) + (new_where.y * new_where.y), 0.5);
	MakeFocus();

	if (axe != 128 && length < arm && length > (arm-128)) {
		note = new Note();
		note->where = where;
		note->area.Set(where.x-DOT_SIZE, 
				where.y-DOT_SIZE, where.x+DOT_SIZE, where.y+DOT_SIZE);
		note->axe = axe; 
		note->pitch = length - (arm-128);
		note->arc = atan2(new_where.x, new_where.y);
		note->isLit = false;
		note->isOn = false;
		note->killMe = false;
		note->color = ((AxeApp *)be_app)->lwindow->CurrentColor();
		note->onTime = -1;
		note->prev = last_note;
		note->next = NULL;

		if (last_note)
			last_note->next = note;
		last_note = note;

		if (!notes)
			notes = note;
		
		Window()->Lock();
		SetHighColor(note->color);
		StrokeEllipse(note->area, B_SOLID_HIGH);
		Window()->Unlock();
	}
}

void BoardView::Clear()
{
	Note *note = notes;
	for (;note; note = note->next)
		note->killMe = true;
}

void BoardView::Load(BFile *file, const char *filename)
{}

void BoardView::WriteNotes(BFile *file)
{}


