#include "AxeApp.h"
#include "AxeDefs.h"

AxeApp::AxeApp() : BApplication('axer')
{
	BRect f;
	srand(system_time()*1000000000);
	window = new AxeWindow();
	f = window->Frame();
	lwindow = new ListWindow(f.LeftTop());
	
	synth = new BMidiSynth();
	synth->EnableInput(true, true);
	lwindow->Show();
	window->Show();
}

/* This must be implemented, otherwise the window doesn't die.
 * Not sure why this is.
 */
bool AxeApp::QuitRequested(void)
{
	return TRUE;
}

void AxeApp::ActivateList()
{
	static bigtime_t now = system_time();
	if (system_time() - now < 250000) {
		now = system_time();
		return;
	}
	lwindow->Activate();
	window->Activate();
	now = system_time();
}

AxeApp::~AxeApp()
{
	synth->AllNotesOff(false);
	snooze(250000);
}

void AxeApp::FieldMoved(BPoint where)
{
	lwindow->Move(where);
}
