#ifndef _AXES
#define _AXES
#include <MidiDefs.h>

typedef struct _axe_thing {
	midi_axe num;
	char *string;
} axe_thing;

typedef struct _axe_list {
	axe_thing *list;
	int32 count;
	rgb_color color;
	char *string;
} axe_list;

#define PIANO_COUNT 8
axe_thing  pianos[] = {
  	{B_ACOUSTIC_GRAND, "Grand Piano"},
 	{B_BRIGHT_GRAND, "Grander Piano"},
 	{B_ELECTRIC_GRAND, "Lesser Piano"},
 	{B_HONKY_TONK, "Grandma's Piano"},
 	{B_ELECTRIC_PIANO_1, "Ugly Piano 1"},
	{B_ELECTRIC_PIANO_2, "Ugly Piano 2"},
	{B_HARPSICHORD, "Harpsichord"},
	{B_CLAVICHORD, "Clavichord"}};

#define IDIOPHONE_COUNT 8
axe_thing idiophones[] = {
	{B_CELESTA, "Celesta"},
 	{B_GLOCKENSPIEL, "Glockenspiegel"},
 	{B_MUSIC_BOX, "Music Box"},
 	{B_VIBRAPHONE, "Vibes"},
 	{B_MARIMBA, "Marimba"},
 	{B_XYLOPHONE, "Xylophone"},
 	{B_TUBULAR_BELLS, "Tubular Bells"},
	{B_TINKLE_BELL, "Tinkle Bells"}};

 
#define ORGAN_COUNT 5
axe_thing organs[] = {
 	{B_DRAWBAR_ORGAN, "Skate Rink Organ"},
 	{B_PERCUSSIVE_ORGAN, "Bang Organ"},
 	{B_ROCK_ORGAN, "Hammond Organ"},
 	{B_CHURCH_ORGAN, "Jesus Organ"},
 	{B_REED_ORGAN, "Wheeze Organ"}};

#define FOLK_COUNT 6 
axe_thing folks[] = {
 	{B_ACCORDION, "Squeeze Box"},
 	{B_HARMONICA, "Harmonica"},
 	{B_TANGO_ACCORDION, "Accordion"},
 	{B_FIDDLE, "Fiddle"},
 	{B_DULCIMER, "Dulcimer"},
   	{B_BANJO, "Banjo"}};
   	
#define GUITAR_COUNT 8
axe_thing guitars[] = { 
 	{B_ACOUSTIC_GUITAR_NYLON, "Nylon Strings"},
 	{B_ACOUSTIC_GUITAR_STEEL, "Steel Strings"},
 	{B_ELECTRIC_GUITAR_JAZZ, "Hollow Body"},
 	{B_ELECTRIC_GUITAR_CLEAN, "Vanilla"},
 	{B_ELECTRIC_GUITAR_MUTED, "Stumble Bum"},
 	{B_OVERDRIVEN_GUITAR, "Nigel"},
 	{B_DISTORTION_GUITAR, "Ian"},
 	{B_GUITAR_HARMONICS, "Ritchie"}};


#define BASS_COUNT 8
axe_thing basses[] = { 
 	{B_ACOUSTIC_BASS, "Upright"},
 	{B_ELECTRIC_BASS_FINGER, "Down Dull"},
 	{B_ELECTRIC_BASS_PICK, "Down Bright"},
 	{B_FRETLESS_BASS, "Jaco"},
 	{B_SLAP_BASS_1, "Slap 1"},
 	{B_SLAP_BASS_2, "Slap 2"},
 	{B_SYNTH_BASS_1, "Lazy 1"},
 	{B_SYNTH_BASS_2, "Lazy 2"}};

#define STRING_COUNT 12
axe_thing strings[] = {  
	{B_VIOLIN, "Violin"},
	{B_VIOLA, "Viola"},
	{B_CELLO, "Cello"},
	{B_CONTRABASS, "Contrabass"},
	{B_TREMOLO_STRINGS, "Agitato"},
	{B_PIZZICATO_STRINGS,  "Pizzicato"},
	{B_ORCHESTRAL_STRINGS,  "Tutti 1"},
	{B_ORCHESTRA_HIT, "Tutti sFz"},
	{B_STRING_ENSEMBLE_1, "Tutti 2"},
	{B_STRING_ENSEMBLE_2, "Tutti 3"},
	{B_SYNTH_STRINGS_1, "Synth Strings 1"},
	{B_SYNTH_STRINGS_2, "Synth Strings 2"}};
 
#define VOICE_COUNT 3
axe_thing voices[] = {
	{B_VOICE_AAH, "Aah"},
	{B_VOICE_OOH, "Ooh"},
	{B_SYNTH_VOICE, "Synth Voices"}};

#define BRASS_COUNT 8
axe_thing brass[] = {
	{B_TRUMPET, "Trumpet"},
	{B_MUTED_TRUMPET, "Mute Trumpet"},
	{B_TROMBONE, "Trombone"},
	{B_TUBA, "Tuba"},
	{B_FRENCH_HORN, "Horn"},
	{B_BRASS_SECTION, "Brass Section"},
	{B_SYNTH_BRASS_1, "Synth Brass 1"},
	{B_SYNTH_BRASS_2, "Synth Brass 2"}};

#define SAX_COUNT 4
axe_thing saxes[] = {
	{B_SOPRANO_SAX, "Soprano"},
	{B_ALTO_SAX, "Alto"},
	{B_TENOR_SAX, "Tenor"},
	{B_BARITONE_SAX, "Baritone"}};
	
#define WIND_COUNT 6
axe_thing winds[] = {	
	{B_OBOE, "Oboe"},
	{B_ENGLISH_HORN, "English Horn"},
	{B_BASSOON, "Bassoon"},
	{B_CLARINET, "Clarinet"},
	{B_PICCOLO, "Piccolo"},
	{B_FLUTE, "Flute"}};

#define PIPE_COUNT 6
axe_thing pipes[] = {	
	{B_RECORDER, "Recorder"},
	{B_PAN_FLUTE, "Pan Flute"},
	{B_BLOWN_BOTTLE, "Bottle"},
	{B_WHISTLE, "Whistle"},
	{B_OCARINA, "Ocarina"},
  	{B_CALLIOPE, "Calliope"}};

#define PERCUSSION_COUNT 8
axe_thing percussion[] = {	
	{B_TIMPANI, "Timpani"},
	{B_MELODIC_TOM, "Tomtom"},
	{B_WOODBLOCK, "Wood Block"},
	{B_AGOGO, "Agogo Bells"},
	{B_STEEL_DRUMS, "Steel Drums"},
	{B_TAIKO_DRUMS, "Taiko Drums"},
	{B_SYNTH_DRUM, "Synth Drum"},
	{B_REVERSE_CYMBAL, "Reverse Cymbal"}};

#define SYNTH_COUNT 7
axe_thing synths[] = {	
	{B_SQUARE_WAVE, "Square Wave"},
	{B_SAWTOOTH_WAVE, "Sawtooth Wave"},
	{B_CHIFF, "Chiff"},
	{B_CHARANG, "Charang"},
	{B_VOICE, "Voice"},
	{B_FIFTHS, "Fifths"},
	{B_BASS_LEAD, "Bass"}};
  
#define EXOTIC_COUNT 7
axe_thing exotics[] = {	
	{B_SITAR, "Sitar"},
	{B_SHAMISEN, "Shamisen"},
	{B_KOTO, "Koto"},
	{B_KALIMBA, "Kalimba"},
	{B_BAGPIPE, "Bagpipe"},
	{B_SHANAI, "Shanai"},
	{B_SHAKUHACHI, "Shakuhachi"}};

#define MFX_COUNT 15
axe_thing mfx[] = {	
	{B_NEW_AGE, "New Age"},
	{B_WARM, "Warm"},
	{B_POLYSYNTH, "Polysynth"},
	{B_CHOIR, "Choir"},
	{B_BOWED, "Bowed"},
	{B_METALLIC, "Metallic"},
	{B_HALO, "Halo"},
	{B_SWEEP, "Sweep"},
	{B_FX_1, "Fido"},
	{B_FX_2, "Surf"},
	{B_FX_3, "Hat Tree"},
	{B_FX_4, "Umbrella"},
	{B_FX_5, "Gum Shoe"},
	{B_FX_6, "Shadow"},
	{B_FX_7, "Manhole"},
	{B_FX_8, "Eye Shadow"}};

#define SFX_COUNT 8
axe_thing sfx[] = {	
	{B_FRET_NOISE, "Frets"},
	{B_BREATH_NOISE, "Breath"},
	{B_SEASHORE, "Ocean"},
	{B_BIRD_TWEET, "Bird"},
	{B_TELEPHONE, "Telephone"},
	{B_HELICOPTER, "Helicopter"},
	{B_APPLAUSE, "Applause"},
	{B_GUNSHOT, "Lee Harvey Oswald"}};

#define AXE_LIST_COUNT 17	
axe_list axe_lists[] = {
	{pianos, PIANO_COUNT, {0,0,0}, "Pianos"},
	{organs, ORGAN_COUNT, {0,0,0}, "Organs"},
	{guitars, GUITAR_COUNT, {0,0,0}, "Guitars"},
	{basses, BASS_COUNT, {0,0,0}, "Basses"},
	{strings, STRING_COUNT, {0,0,0}, "Strings"},
	{brass, BRASS_COUNT, {0,0,0}, "Brass"},
	{winds, WIND_COUNT, {0,0,0}, "Winds"},
	{saxes, SAX_COUNT, {0,0,0}, "Saxes"},
	{voices, VOICE_COUNT, {0,0,0}, "Voices"},
	{pipes, PIPE_COUNT, {0,0,0}, "Pipes"},
	{percussion, PERCUSSION_COUNT, {0,0,0}, "Percussion"},
	{idiophones, IDIOPHONE_COUNT, {0,0,0}, "Idiophones"},
	{exotics, EXOTIC_COUNT, {0,0,0}, "Exotics"},
	{folks, FOLK_COUNT, {0,0,0}, "Folks"},
	{synths, SYNTH_COUNT, {0,0,0}, "Synths"},
	{mfx, MFX_COUNT, {0,0,0}, "Music FX"},
	{sfx, SFX_COUNT, {0,0,0}, "Sound FX"}};
	//{NULL, 0, {0,0,0}, "Ringo"}};
	
#endif
