#ifndef _LIST_WINDOW
#define _LIST_WINDOW
#include <Window.h>
#include "AxeDefs.h"
#include "axes.h"
#include <MidiDefs.h>

#include <ListView.h>
#include <ListItem.h>

class AxeList : public BListView
{
	public:
		AxeList(BRect rect, char *name);
		void SelectionChanged(void);
		int32 current_selection;
};

class AxeItem : public BListItem
{
	public:
		AxeItem(axe_thing *thing);
		void DrawItem(BView *owner,
							BRect bounds,
							bool complete = false);
		axe_thing *thing;
};

class GroupItem : public BListItem
{
	public:
		GroupItem(axe_list *thing);
		void DrawItem(BView *owner,
							BRect bounds,
							bool complete = false);
		axe_list *thing;
};

class ListWindow : public BWindow
{
	public:
		ListWindow(BPoint where);
	//	~ListWindow();
		
		void Move(BPoint where);
		void SelectGroup(int32 which);
		midi_axe CurrentAxe();
		rgb_color CurrentColor();
		AxeList *group_view, *axe_view[AXE_LIST_COUNT];
		BView *background;
		int32 current_group;
};

#endif
