#ifndef _BOARD_VIEW
#define _BOARD_VIEW
#include "AxeDefs.h"
#include <View.h>
#include <MidiDefs.h>
#include <OS.h>
#include <Entry.h>
#include <File.h>
#include <Bitmap.h>
#include <Shelf.h>

class Note 
{
	public:
		Note();
		BRect area;
		BPoint where;
		midi_axe axe;
		uint8 pitch;
		float arc;
		bool isLit;
		bool isOn;
		bool killMe;
		rgb_color color;
		bigtime_t onTime;
		Note *prev;
		Note *next;
};

class BoardView : public BView
{
	public:
		BoardView(float v_off);
		StopBlipper();
		StartBlipper();
		void Draw(BRect update);
		void Blip();
		bigtime_t start_time;
		float arm;
		BPoint blip;
		float blip_arc;
		BPoint center;
		thread_id blipper;	
		bool go, dead_down;
		int32 nm_ktr, nm_max;
		Note *notes, *last_note;		
		BBitmap *bmap;
		BView *bit_view;
		void FillBitmap();
		void MouseDown(BPoint where);
		void KeyDown(const char *bytes, int32 numBytes);
		void AttachedToWindow();
		void NewDeadColor();
		void Clear();
		void Load(BFile *file, const char *filename);
		void WriteNotes(BFile *file);
		BShelf *shelf;
};
#endif