#ifndef _AXE_WINDOW
#define _AXE_WINDOW
#include <Window.h>
#include "BoardView.h"
#include "AxeDefs.h"
#include "axes.h"
#include <Path.h>
#include <FilePanel.h>
#include <MidiDefs.h>

class PathList :public BPath
{
	public:
		PathList();
		BPath *next;
		BPath *prev;
};

class AxeWindow : public BWindow
{
	public:
		AxeWindow();
		~AxeWindow();
		
		void MessageReceived(BMessage *msg);
		void FrameMoved(BPoint where);
		bool QuitRequested();
		void WindowActivated(bool state);
		float AddMenus();
		void ShowFileList();
		void SaveFile(BMessage *msg);
		void LoadFile(BMessage *msg);
		BoardView *board_view;
		BView *background;
		PathList *paths;	
		BFilePanel *open_panel, *save_panel;
};

#endif
