#include "AxeWindow.h"
#include "AxeApp.h"
PathList::PathList() : BPath()
{
	next = NULL;
	prev = NULL;
}

AxeWindow::AxeWindow():BWindow(BRect(20,20, W_W+20, W_H+20), "axe",
	B_TITLED_WINDOW, B_NOT_RESIZABLE|B_NOT_ZOOMABLE|
	B_WILL_ACCEPT_FIRST_CLICK)
{
	float menu_height;
	
	background = new BView(BRect(0,0,W_W, W_H), "background", B_FOLLOW_ALL,
		B_WILL_DRAW);
	background->SetViewColor(BackgroundColor);
	AddChild(background);

	menu_height = AddMenus();

	board_view = new BoardView(menu_height+1);
	background->AddChild(board_view);
	ResizeBy(0, menu_height+1);

	paths = NULL;
	open_panel = new BFilePanel(B_OPEN_PANEL, &BMessenger(this),
		NULL, B_FILE_NODE | B_DIRECTORY_NODE);

	save_panel = new BFilePanel(B_SAVE_PANEL, &BMessenger(this));

}

AxeWindow::~AxeWindow(void)
{
	delete open_panel;
	delete save_panel;
	Unlock();
	board_view->StopBlipper();
	Lock();
}


void AxeWindow::WindowActivated(bool state)
{
	if (state)
		((AxeApp *)be_app)->ActivateList();
}

float AxeWindow::AddMenus()
{
	BMenuBar *bar;
	BMenu *menu;
	
	bar = new BMenuBar(BRect(0,0,0,0), "menu");
	menu = new BMenu("File");
	menu->AddItem(new BMenuItem("Open", new BMessage(LOAD_FILE), 'O'));
	menu->AddItem(new BMenuItem("Add", new BMessage(ADD_FILE), 'A'));
	menu->AddItem(new BMenuItem("List", new BMessage(LIST_FILE), 'L'));
	menu->AddItem(new BMenuItem("Save", new BMessage(SAVE_FILE), 'S'));
	menu->AddItem(new BMenuItem("Save As", new BMessage(SAVE_FILE_AS)));
 	bar->AddItem(menu);
 	background->AddChild(bar);
	return bar->Bounds().bottom;
}

void AxeWindow::FrameMoved(BPoint where)
{
	((AxeApp *)be_app)->FieldMoved(where);
}

void AxeWindow::MessageReceived(BMessage *msg)
{
	BMessage fmsg;
	switch (msg->what) {
		case LOAD_FILE:
			fmsg.what = B_REFS_RECEIVED;
			fmsg.AddInt32("extra", msg->what);
			open_panel->SetMessage(&fmsg);
			open_panel->Show();
			break;
		case ADD_FILE:
			fmsg.what = B_REFS_RECEIVED;
			fmsg.AddInt32("extra", msg->what);
			open_panel->SetMessage(&fmsg);
			open_panel->Show();
			break;
		case LIST_FILE:
			//((AxeApp *)be_app)->lwindow->Lock();
			//((AxeApp *)be_app)->lwindow->Show();
		//	((AxeApp *)be_app)->lwindow->Unlock();
			ShowFileList();
			break;
		case SAVE_FILE:
			if (paths && !paths->next) {
				SaveFile(msg);
				break;
			}
			PostMessage(SAVE_FILE_AS);
			break;
		case SAVE_FILE_AS:
			save_panel->Show();
			break;
		case B_REFS_RECEIVED:
			LoadFile(msg);
			break;
		case B_SAVE_REQUESTED:
			SaveFile(msg);
			break;
		default:
			break;
	}
}

void AxeWindow::LoadFile(BMessage *msg)
{
	int32 add;
	BEntry entry;
	entry_ref ref;
	BPath path;
	int32 ktr=0;
	BFile file;
	
	msg->FindInt32("extra", &add);
	if (add == LOAD_FILE) 
		board_view->Clear();
	while (msg->FindRef("refs", ktr++, &ref) == B_NO_ERROR) {
		entry.SetTo(&ref);
		entry.GetPath(&path);
		file.SetTo(&entry, B_READ_ONLY);
		board_view->Load(&file, path.Path());
	}
}

void AxeWindow::SaveFile(BMessage *msg)
{
	entry_ref ref;
	char *file_name;
	BFile file;
	BDirectory dir;
	msg->FindRef("directory", &ref);
	msg->FindString("name", &file_name);
	dir.SetTo(&ref);
	file.SetTo(&dir, file_name, B_WRITE_ONLY | B_ERASE_FILE);
	board_view->WriteNotes(&file);
}

void AxeWindow::ShowFileList()
{
}

bool AxeWindow::QuitRequested(void)
{
	be_app->PostMessage(B_QUIT_REQUESTED, be_app);
	return FALSE;
}
