//******************************************************************************
//
//	File:		timecode.h
//
//	Description:	timecode class header.
//	
//	Copyright 1997, Be Incorporated, All Rights Reserved.
//
//******************************************************************************


#ifndef	_TIMECODE_H
#define	_TIMECODE_H

#include <SupportDefs.h>

typedef enum{
	DEFAULT_TYPE
}timecode_type;

class timecode {

public:
		int8				hour;
		int8				minute;
		int8				second;
		int8				frame;
		timecode_type		type;

		// constructors
		timecode();
		timecode(	int8 h,
					int8 m,
					int8 s,
					int8 f,
					timecode_type type = DEFAULT_TYPE);
		timecode(const timecode& tc);
		
		// assignment
		timecode	&operator=(const timecode &from);
		void		Set(int8 h,
						int8 m,
						int8 s,
						int8 f,
						timecode_type type = DEFAULT_TYPE);

		// arithmetic
		timecode	&operator++();

		// relational
		bool		operator!=(const timecode&) const;
		bool		operator==(const timecode&) const;
		
};

inline timecode::timecode()
{
	hour = 0;
	minute = 0;
	second = 0;
	frame = 0;
	type = DEFAULT_TYPE;
}

inline timecode::timecode(	int8 h,
							int8 m,
							int8 s,
							int8 f,
							timecode_type t)
{
	hour = h;
	minute = m;
	second = s;
	frame = f;
	type = t;
}

inline timecode::timecode(const timecode& tc)
{
	hour = tc.hour;
	minute = tc.minute;
	second = tc.second;
	frame = tc.frame;
	type = tc.type;
}

inline timecode &timecode::operator=(const timecode& from)
{
	// don't need to worry about "this==from"
	hour = from.hour;
	minute = from.minute;
	second = from.second;
	frame = from.frame;
	type = from.type;
	return *this;
}

inline void timecode::Set(	int8 h,
							int8 m,
							int8 s,
							int8 f,
							timecode_type t)
{
	hour = h;
	minute = m;
	second = s;
	frame = f;
	type = t;
}

#endif
