#ifndef TICKER_H
#define TICKER_H

#include "thread.h"

class tick;

const uint32	MAX_CONNECTIONS	= 255;

class ticker : public thread
{
public:
			ticker(const char *name="ticker_thread", uint32 frequency = 1000000, long aPriority = B_NORMAL_PRIORITY);
			ticker(bigtime_t period = 1000000, const char *name="ticker_thread", long aPriority = B_NORMAL_PRIORITY);

			uint32		Frequency();
			void		SetFrequency(uint32 frequency);

			bigtime_t	Period();
			void		SetPeriod(bigtime_t period);
			
	virtual	status_t	Start();
	virtual	void		Stop();
			bool		IsStopping() const;
	
			status_t	Connect(port_id toPort);
			void		Disconnect(port_id fromPort);
			bool		IsConnected(port_id toPort) const;
	
	virtual void		OutputTick(	bigtime_t time, 
									bigtime_t period, 
									uint64 count);

			port_id		fConnectionList[MAX_CONNECTIONS];

private:
	virtual	status_t	ThreadMain();	//overridden from thread

			bigtime_t	fPeriod;		//microsecs per tick
			uint32		fFrequency;		//ticks per second (Hz)
			bool		fIsStopping;

};

#endif //TICKER_H