//****************************************************************************
//
//	File:			chaser.h
//
//	Description:	chaser object class.
//
//	Copyright 1998, Be Incorporated
//
//****************************************************************************

#ifndef CHASER_H
#define CHASER_H

#include "thread.h"

class tick;

class chaser : public thread
{
public:
	chaser(void (*ticked_func)(void *arg, tick *t), void *arg, const char *name, int32 aPriority);

	virtual	status_t	Start();
	virtual	void		Stop();
			bool		IsStopping();
			
			port_id		PortID() const;
			
private:
	virtual	status_t	ThreadMain();						//overridden from thread
			void		(*Ticked)(void *arg, tick *t);		//points to ticked_func
			
			void		*fCaller;
			port_id		fPortID;
			bool		fIsStopping;
};

#endif //_CHASER_H
