//******************************************************************************
//
//	File:			chaser.cpp
//
//	Description:	chaser object class.
//
//	Written by:		Douglas Wright
//
//	Copyright 1998, Be Incorporated
//
//****************************************************************************

#include "chaser.h"
#include "tick.h"

/*------------------------------------------------------------*/

const uint32	MAX_QUEUED_MSGS	= 1;

/*------------------------------------------------------------*/

chaser::chaser(void (*ticked_func)(void *arg, tick *t), 
				void *arg, 
				const char *name="ticker_thread", 
				int32 aPriority = B_NORMAL_PRIORITY)
		:thread(name, aPriority)
{
  	Ticked = ticked_func;
  	fCaller = arg;
  	fIsStopping = false;
  	fPortID = -1;
  	Start();
}

/*------------------------------------------------------------*/

status_t
chaser::Start()
{
	fPortID = create_port(MAX_QUEUED_MSGS, "tickInPort");
	if (fPortID < 0)
	  	return PortID();

	return Run();
}

/*------------------------------------------------------------*/

void
chaser::Stop()
{
	fIsStopping = true;
	long dummy;
	WaitForExit(&dummy);
}

/*------------------------------------------------------------*/

bool 
chaser::IsStopping()
{
	return fIsStopping;
}

/*------------------------------------------------------------*/

port_id		
chaser::PortID() const
{ 
  return fPortID; 
}

/*------------------------------------------------------------*/

status_t
chaser::ThreadMain()
{
  	tick *t = new tick();

  	long err = 0;

	while(!IsStopping()){
		long msg = 0;
		if (err < 0 && err != B_INTERRUPTED)
	  		break;

		ssize_t msgSize = port_buffer_size(fPortID);
		if (msgSize < 0) {
	  		err = msgSize;
	  		continue;
		}
		
		if (msgSize == sizeof(*t)) {
	  		err = read_port(fPortID, &msg, t, sizeof(*t));
	  		if (err < 0){
				continue;
			}
				
	  		if (msg == TICK_MSG){
				(*Ticked)(fCaller, t);
			}
		}
  	}
  	return B_OK;
}

/*------------------------------------------------------------*/