/*
	YAGSTest

	This program simply exercises some of the YAGS drawing
	primitives.
	
	It gets a hold of the screen buffer, and starts doing
	some drawing.
*/

#include <Application.h>
#include <stdio.h>
#include <stdlib.h>
#include "yagstst.h"
#include "screen.h"
#include "effects.h"


//===================================================================
// Class: AHandler 
//
// This class deals with messages.  In particular it is injected into
// the window to handle messages like keydown.
//
//===================================================================

class AHandler : public BHandler
{
public:
			AHandler(AYAGSScreen *screen);
			
	virtual void MessageReceived(BMessage *message);

protected:
	AYAGSScreen *fScreen;
	
private:

};


AHandler::AHandler(AYAGSScreen *screen)
	: fScreen(screen)
{
}


void	
AHandler::MessageReceived(BMessage *message)	
{
	printf("AHandler::MessageReceived - %d\n", message->what);
	
	switch (message->what) 
	{
		case B_KEY_DOWN:
		{
			long key = message->FindLong("key");
			long aChar = message->FindLong("char");
			switch(aChar)
			{
				case B_ESCAPE:
					be_app->PostMessage(B_QUIT_REQUESTED);
				break;

				case '3':	// Test 3D Lines
					TestLine3D(fScreen, 0,0,fScreen->width, fScreen->height);
				break;

				case 'c':
					TestCircle(fScreen, 0,0,fScreen->width, fScreen->height);
				break;

				case 'd':	// Test Points (dots)
					TestPoint(fScreen, 0,0,fScreen->width, fScreen->height);
				break;

				case 'e':	// Test ellipse
					TestEllipse(fScreen, 0,0,fScreen->width, fScreen->height);
				break;

				case 'g':	// Do all the tests in sequence
					TestLine(fScreen, 0,0,fScreen->width, fScreen->height);
					Y2DEffectBarnOpen(*fScreen, 0,0,fScreen->width, fScreen->height, 0, 200);
			
					TestTriangle(fScreen, 0,0,fScreen->width, fScreen->height);
					Y2DEffectWipeFromRight(*fScreen, 0,0,fScreen->width, fScreen->height, 0, 200);
			
					TestRectangle(fScreen, 0,0,fScreen->width, fScreen->height);
					Y2DEffectWipeFromLeft(*fScreen, 0,0,fScreen->width, fScreen->height, 0, 200);
			
					//TestQuad(fScreen, 0,0,fScreen->width, fScreen->height);
					//Y2DEffectWipeFromLeft(*fScreen, scInfo.frame, 0, 200);
			
					TestCircle(fScreen, 0,0,fScreen->width, fScreen->height);
					Y2DEffectWipeFromTop(*fScreen, 0,0,fScreen->width, fScreen->height, 0, 200);

					TestEllipse(fScreen, 0,0,fScreen->width, fScreen->height);
					Y2DEffectWipeFromBottom(*fScreen, 0,0,fScreen->width, fScreen->height, 0, 600);
				break;
				
				case 'l':	// Test Lines
					TestLine(fScreen, 0,0,fScreen->width, fScreen->height);
				break;

				case 'r':	// Test Rectangle
					TestRectangle(fScreen, 0,0,fScreen->width, fScreen->height);
				break;

				case 't':
					TestTriangle(fScreen, 0,0,fScreen->width, fScreen->height);
				break;
			}
		}
	
		default:
			// Just forward all messages to the be_app
			be_app->PostMessage(message);	
		break;
	}
	
#if 0
	switch (message->what) 
	{
		case B_KEY_DOWN:
		{
			long key = message->FindLong("key");
			long aChar = message->FindLong("char");
			switch(aChar)
			{
				case '1':	// Test Bezier	
					TestBezier(fScreen, 0,0,fScreen.width, fScreen.height);
				break;
		
		
				case 'a':	// Do all tests in parallel
					TestAll(fScreen, 0,0,fScreen.width, 200);
				break;
		
				case 'b':
					TestBitmap(fScreen, 0,0,fScreen.width, fScreen.height);
				break;
		
				case 'q':	// Test Quadrilaterals
					TestQuad(fScreen, 0,0,fScreen.width, fScreen.height);
				break;

				case 's':
					TestEffects(fScreen, 0,0,fScreen.width, fScreen.height);
				break;

			}
		}
	}
#endif
}

/*
**	AApplication
*/

class AApplication : public BApplication
{
public:
		AApplication();
	
	// Inherited from BLooper
	virtual	bool	QuitRequested();

	AYAGSScreen *fWindow;
	AHandler	*fHandler;
};

AApplication::AApplication()
	:BApplication('YTST')
{
	fWindow = new AYAGSScreen();
	fHandler = new AHandler(fWindow);
	fWindow->AddHandler(fHandler);
}


bool
AApplication::QuitRequested()
{		
	// Quit the presentation to give up the window
	fWindow->Quit();
			
	return TRUE;
}

main()
{	
	AApplication *myApplication;
	
	myApplication = new AApplication();
	
	myApplication->Run();

	delete(myApplication);
	return(0);
}
