#include "yags2d.h"
#include <stdio.h>

void
Y2DRect(pixel_buffer screenInfo,
	const U16 left, const U16 top,
	const U16 right, const U16 bottom,
	const U08 aColor)
{
 	// Use the optimized line drawing routines to draw the sides.	
	// Do the top and bottom lines
	Y2DHLine(screenInfo, left,top,right,top, aColor); 
	Y2DHLine(screenInfo, left,bottom,right,bottom, aColor); 
		
	// Do the left and right lines
	Y2DVLine(screenInfo, left,top,left,bottom, aColor); 
	Y2DVLine(screenInfo, right,top,right,bottom, aColor); 
}

void
Y2DRectFill(pixel_buffer screenInfo,
	const U16 left, const U16 top,
	const U16 right, const U16 bottom,
	const U08 aColor)
{	
	//U08 *rowPtr = &((U08*)screenInfo.bits)[top*screenInfo.bytes_per_row+left];
	//U16 width = right - left;
	
	U16 y;
	for (y=top; y<=bottom; y++)
	{
		Y2DHLine(screenInfo, left,y,right,y, aColor); 
		//Y2DHSpan(rowPtr, aColor, width);
		//rowPtr += screenInfo.bytes_per_row;
	}
}

void
Y2DClear(pixel_buffer screenInfo, const U08 aColor)
{
	Y2DRectFill(screenInfo, screenInfo.x, screenInfo.y,
		screenInfo.x+screenInfo.width-1, screenInfo.y+screenInfo.height-1, 
		aColor);
}
