#include "yags2d.h"

void	
Y2DQuad(pixel_buffer scrInfo,
	const U16 x1, const U16 y1,
	const U16 x2, const U16 y2,
	const U16 x3, const U16 y3,
	const U16 x4, const U16 y4,
	const U08 aColor)
{
	// Draw four connecting lines
	Y2DLine(scrInfo, x1, y1, x2, y2, aColor);
	Y2DLine(scrInfo, x2, y2, x3, y3, aColor);
	Y2DLine(scrInfo, x3, y3, x4, y4, aColor);
	Y2DLine(scrInfo, x4, y4, x1, y1, aColor);

}

void	
Y2DQuadFill(pixel_buffer scrInfo,
	const U16 x1, const U16 y1,
	const U16 x2, const U16 y2,
	const U16 x3, const U16 y3,
	const U16 x4, const U16 y4,
	const U08 aColor)
{
	U16 X1=x1, X2=x2, X3=x3, X4=x4;
	U16 Y1=y1, Y2=y2, Y3=y3, Y4=y4;
	U16 temp_x, temp_y;
	
	// sort p1,p2,p3,p4 in ascending y order

	if (Y2<Y1)
	{
		temp_x = X2;
		temp_y = Y2;
		X2     = X1;
		Y2     = Y1;
		X1     = temp_x;
		Y1     = temp_y;
	} // end if

	// now we know that p1 and p2 are in order

	if (Y3<Y1)
	{
		temp_x = X3;
		temp_y = Y3;
		X3     = X1;
		Y3     = Y1;
		X1     = temp_x;
		Y1     = temp_y;
	} // end if

	// finally test y3 against y2
	if (Y3<Y2)
	{
		temp_x = X3;
		temp_y = Y3;
		X3     = X2;
		Y3     = Y2;
		X2     = temp_x;
		Y2     = temp_y;

	} // end if
	
	
	// now we know that p1, p2, and p3 are in order

	if (Y4<Y1)
	{
		temp_x = X4;
		temp_y = Y4;
		X4     = X1;
		Y4     = Y1;
		X1     = temp_x;
		Y1     = temp_y;
	} // end if

	// test y4 against y2
	if (Y4<Y2)
	{
		temp_x = X4;
		temp_y = Y4;
		X4     = X2;
		Y4     = Y2;
		X2     = temp_x;
		Y2     = temp_y;

	} // end if
	
	if (Y4<Y3)
	{
		temp_x = X4;
		temp_y = Y4;
		X4     = X3;
		Y4     = Y3;
		X3     = temp_x;
		Y3     = temp_y;
	} // end if

	// Draw two triangles
	// We could do scan conversion right here, but the
	// triangle code is way optimized already and we'd only
	// be saving the time of a function call.
	Y2DTriangleFill(scrInfo, X1, Y1, X2, Y2, X3, Y3, aColor);
	Y2DTriangleFill(scrInfo, X2, Y2, X3, Y3, X4, Y4, aColor);
}

