/*
	YAGSTest

	This program simply exercises some of the YAGS drawing
	primitives.
	
	It gets a hold of the screen buffer, and starts doing
	some drawing.
*/

#include <Application.h>
#include <WindowScreen.h>
#include <Screen.h>
#include <stdio.h>
#include <stdlib.h>
#include "random.h"
#include "yagstest.h"
#include "effects.h"

pixel_buffer fScreen;

static void
TestPolygon(pixel_buffer scrInfo,const Point2Ds* pts, const unsigned long npts)
{
	// Clear the screen to black
	Y2DRectFill(scrInfo,0,0,scrInfo.width, scrInfo.height,0);
	
	unsigned char aColor=0;
	Y2DPrimitives(scrInfo, Y2D_POLYGON, pts, npts, aColor);
}


static void
TestBezier(pixel_buffer scrInfo, const U16 left, const U16 top,
	const U16 width, const U16 height)
{
	U16 segs = 15;
	Point2Df pts[10];
	U16 nPts = 5;
	
	pts[0].x = 100; pts[0].y = 300;
	pts[1].x = 100; pts[1].y = 40;
	pts[2].x = 400; pts[2].y = 40;
	pts[3].x = 200; pts[3].y = 150;
	pts[4].x = 100; pts[4].y = 300;
		
	Y2DBezier(nPts, pts, 58, segs, scrInfo);
}

static void
TestAll(pixel_buffer scInfo, U16 x, U16 y, U16 width, U16 height)
{
/*
	U16 width = frame.Width()-1;
	U16 height = frame.Height()-1;
	
	testParam tstpoint;
	tstpoint.fScreenInfo = scInfo;
	tstpoint.fFrame = BRect(0,0, width/4,height/2);
	
	testParam tstline;
	tstline.fScreenInfo = scInfo;
	tstline.fFrame = BRect(width/4,0, (width*2)/4,height/2);
	
	testParam tsttriangle;
	tsttriangle.fScreenInfo = scInfo;
	tsttriangle.fFrame = BRect(width/2,0,width*3/4,height/2);
	
	testParam tstrectangle;
	tstrectangle.fScreenInfo = scInfo;
	tstrectangle.fFrame = BRect(width*3/4,0,width,height/2);
	
	testParam tstcircle;
	tstcircle.fScreenInfo = scInfo;
	tstcircle.fFrame = BRect(0,height/2,width/4,height);
	
	testParam tstellipse;
	tstellipse.fScreenInfo = scInfo;
	tstellipse.fFrame = BRect(width/4,height/2, (width*2)/4,height);
	
	testParam tstquad;
	tstquad.fScreenInfo = scInfo;
	tstquad.fFrame = BRect(width/2,height/2,width*3/4,height);
*/

	float hslots = 8;
	
	testParam tstpoint;
	tstpoint.fScreenInfo = scInfo;
	tstpoint.fFrame = BRect(0,0, width*(1.0/hslots),height);
	
	testParam tstline;
	tstline.fScreenInfo = scInfo;
	tstline.fFrame = BRect(width*(1.0/hslots),0, width*(2.0/hslots),height);
	
	testParam tsttriangle;
	tsttriangle.fScreenInfo = scInfo;
	tsttriangle.fFrame = BRect(width*(2.0/hslots),0,width*(3.0/hslots),height);
	
	testParam tstrectangle;
	tstrectangle.fScreenInfo = scInfo;
	tstrectangle.fFrame = BRect(width*(3.0/hslots),0,width*(4.0/hslots),height);
	
	testParam tstcircle;
	tstcircle.fScreenInfo = scInfo;
	tstcircle.fFrame = BRect(width*(4.0/hslots),0,width*(5.0/hslots),height);
	
	testParam tstellipse;
	tstellipse.fScreenInfo = scInfo;
	tstellipse.fFrame = BRect(width*(5.0/hslots),0, width*(6.0/hslots),height);
	
	testParam tstquad;
	tstquad.fScreenInfo = scInfo;
	tstquad.fFrame = BRect(width*(6.0/hslots),0,width*(7.0/hslots),height);
	
	resume_thread(spawn_thread(TestPointThread, "TestPoint", B_NORMAL_PRIORITY, &tstpoint));
	resume_thread(spawn_thread(TestLineThread, "TestLine", B_NORMAL_PRIORITY, &tstline));
	resume_thread(spawn_thread(TestTriangleThread, "TestTriangle", B_NORMAL_PRIORITY, &tsttriangle));
	resume_thread(spawn_thread(TestRectangleThread, "TestRect", B_NORMAL_PRIORITY, &tstrectangle));
	resume_thread(spawn_thread(TestCircleThread, "TestCircle",B_NORMAL_PRIORITY, &tstcircle));
	resume_thread(spawn_thread(TestEllipseThread, "TestEllipse",B_NORMAL_PRIORITY, &tstellipse));
	//resume_thread(spawn_thread(TestQuadThread, "TestQuad",B_NORMAL_PRIORITY, &tstquad));
}


//=====================================================================
//	Class: ADemoWindow
//=====================================================================


class ADemoWindow : public BWindowScreen
{

public:
				ADemoWindow(status_t *error); 
	
	virtual	void	Quit();
	virtual	void	Show();
	virtual void	ScreenConnected(bool active);
	virtual void	MessageReceived(BMessage *message);
};

ADemoWindow::ADemoWindow(status_t *error)
	: BWindowScreen("YAGS", B_8_BIT_640x480, error)
{
}

void 
ADemoWindow::Quit()
{
	//Disconnect();
	
	// Quit the WindowScreen.
	inherited::Quit();
}

void        
ADemoWindow::ScreenConnected(bool active)
{
	inherited::ScreenConnected(active);
	printf("ScreenConnected: %d\n", active);

		fScreen.mode = B_COLOR_8_BIT;
		fScreen.pixels = (unsigned char *)CardInfo()->frame_buffer;
		fScreen.bytes_per_row = CardInfo()->bytes_per_row;
		fScreen.width = CardInfo()->width;
		fScreen.height = CardInfo()->height;
		
		rgb_color    palette[256];
		palette[0].red = 0;
		palette[0].green = 0;
		palette[0].blue = 0;
		for (int i=1;i<255;i++) 
		{
			palette[i].red = rand();
			palette[i].green = rand();
			palette[i].blue = rand();
		}
		SetColorList(palette);
}

void 
ADemoWindow::Show()
{
	inherited::Show();
		printf("ADemoWindow::Show\n");

	BScreen screen;
	fScreen.mode = B_COLOR_8_BIT;
	fScreen.pixels = (unsigned char *)screen.BaseAddress();
	fScreen.bytes_per_row = screen.BytesPerRow();
	fScreen.width = screen.Frame().IntegerWidth()+1;
	fScreen.height = screen.Frame().IntegerHeight()+1;
}

void	
ADemoWindow::MessageReceived(BMessage *message)	
{
	//printf("ADemoWindow::MessageReceived - %d\n", message->what);
	
	switch (message->what) 
	{
		case B_KEY_DOWN:
		{
			int8 aChar;
			message->FindInt8("byte", &aChar);
			switch(aChar)
			{
				case B_ESCAPE:
					be_app->PostMessage(B_QUIT_REQUESTED);
				break;

				case '1':	// Test Bezier	
					TestBezier(fScreen, 0,0,fScreen.width, fScreen.height);
				break;

				case '3':	// Test 3D Lines
					TestLine3D(fScreen, 0,0,fScreen.width, fScreen.height);
				break;

				case 'a':	// Do all tests in parallel
					TestAll(fScreen, 0,0,fScreen.width, 200);
				break;
		

				//case 'b':
				//	TestBitmap(fScreen, 0,0,fScreen.width, fScreen.height);
				//break;
	
				case 'c':
					TestCircle(fScreen, 0,0,fScreen.width, fScreen.height);
				break;

				case 'd':	// Test Points (dots)
					TestPoint(fScreen, 0,0,fScreen.width, fScreen.height);
				break;
		
				case 'e':	// Test ellipse
					TestEllipse(fScreen, 0,0,fScreen.width, fScreen.height);
				break;

				case 'g':	// Do all the tests in sequence
					TestPoint(fScreen, 0,0,fScreen.width, fScreen.height);
					//Y2DEffectBarnOpen(fScreen, scInfo.frame, 0, 200);
			
					TestLine(fScreen, 0,0,fScreen.width, fScreen.height);
					//Y2DEffectBarnClose(fScreen, scInfo.frame, 0, 200);
			
					TestTriangle(fScreen, 0,0,fScreen.width, fScreen.height);
					//Y2DEffectWipeFromRight(fScreen, scInfo.frame, 0, 200);
			
					TestRectangle(fScreen, 0,0,fScreen.width, fScreen.height);
					//Y2DEffectWipeFromLeft(fScreen, scInfo.frame, 0, 200);
			
					//TestQuad(fScreen, 0,0,fScreen.width, fScreen.height);
					//Y2DEffectWipeFromLeft(fScreen, scInfo.frame, 0, 200);
			
					TestCircle(fScreen, 0,0,fScreen.width, fScreen.height);
					//Y2DEffectWipeFromTop(fScreen, scInfo.frame, 0, 200);
			
					TestEllipse(fScreen, 0,0,fScreen.width, fScreen.height);
					//Y2DEffectWipeFromBottom(fScreen, scInfo.frame, 0, 600);
					//Y2DEffectFadeToBlack(fScreen, 5);
			
				break;
		
				case 'l':	// Test Lines
					TestLine(fScreen, 0,0,fScreen.width, fScreen.height);
				break;
		

				//case 'q':	// Test Quadrilaterals
				//	TestQuad(fScreen, 0,0,fScreen.width, fScreen.height);
				//break;
		
				case 'r':	// Test Rectangle
					TestRectangle(fScreen, 0,0,fScreen.width, fScreen.height);
				break;
		
				//case 's':
				//	TestEffects(fScreen, 0,0,fScreen.width, fScreen.height);
				//break;
		
				case 't':
					TestTriangle(fScreen, 0,0,fScreen.width, fScreen.height);
				break;

				default:
					// Do Nothing by default
				break;
			}
		}
	}
	
}


//	AApplication


class AApplication : public BApplication
{
public:
		AApplication();
	
	// Inherited from BLooper
	virtual	bool	QuitRequested();

	ADemoWindow *fWindow;
};

AApplication::AApplication()
	:BApplication('YTST')
{
	BScreen screen;
	status_t status;
	
	printf("AApplication - 1.0\n");
	fWindow = new ADemoWindow(&status);
	//printf("AApplication - 1.1\n");
	fWindow->Show();
	//printf("AApplication - 1.2\n");
	
	printf("pixels: %x\n", fScreen.pixels);
	printf("width: %d\n", fScreen.width);
	printf("height: %d\n", fScreen.height);
		

	//fScreen.mode = B_COLOR_8_BIT;
	//fScreen.pixels = (unsigned char *)screen.BaseAddress();
	//fScreen.bytes_per_row = screen.BytesPerRow();
	//fScreen.width = screen.Frame().IntegerWidth()+1;
	//fScreen.height = screen.Frame().IntegerHeight()+1;
}


bool
AApplication::QuitRequested()
{		
	// Quit the presentation to give up the window
	//fWindow->Quit();
			
	return true;
}

main()
{	
	AApplication *myApplication;
	
	myApplication = new AApplication();
	
	myApplication->Run();

	delete(myApplication);
	return(0);
}



#if 0
main()
{
	BScreen screen;
	
	printf("AApplication - 1.0\n");
	
	fScreen.mode = B_COLOR_8_BIT;
	fScreen.pixels = (unsigned char *)screen.BaseAddress();
	fScreen.bytes_per_row = screen.BytesPerRow();
	fScreen.width = screen.Frame().IntegerWidth()+1;
	fScreen.height = screen.Frame().IntegerHeight()+1;
	
	bool goone = true;
	
	while (goone)
	{
		int c = getchar();
		switch (c) 
		{
				case 'q':
					goone = false;
				break;

				case '1':	// Test Bezier	
					TestBezier(fScreen, 0,0,fScreen.width, fScreen.height);
				break;

				case '3':	// Test 3D Lines
					TestLine3D(fScreen, 0,0,fScreen.width, fScreen.height);
				break;

				case 'a':	// Do all tests in parallel
					TestAll(fScreen, 0,0,fScreen.width, 200);
				break;
		
/*
				case 'b':
					TestBitmap(fScreen, 0,0,fScreen.width, fScreen.height);
				break;
*/		
				case 'c':
					TestCircle(fScreen, 0,0,fScreen.width, fScreen.height);
				break;

				case 'd':	// Test Points (dots)
					TestPoint(fScreen, 0,0,fScreen.width, fScreen.height);
				break;
		
				case 'e':	// Test ellipse
					TestEllipse(fScreen, 0,0,fScreen.width, fScreen.height);
				break;

				case 'g':	// Do all the tests in sequence
					TestPoint(fScreen, 0,0,fScreen.width, fScreen.height);
					//Y2DEffectBarnOpen(fScreen, scInfo.frame, 0, 200);
			
					TestLine(fScreen, 0,0,fScreen.width, fScreen.height);
					//Y2DEffectBarnClose(fScreen, scInfo.frame, 0, 200);
			
					TestTriangle(fScreen, 0,0,fScreen.width, fScreen.height);
					//Y2DEffectWipeFromRight(fScreen, scInfo.frame, 0, 200);
			
					TestRectangle(fScreen, 0,0,fScreen.width, fScreen.height);
					//Y2DEffectWipeFromLeft(fScreen, scInfo.frame, 0, 200);
			
					//TestQuad(fScreen, 0,0,fScreen.width, fScreen.height);
					//Y2DEffectWipeFromLeft(fScreen, scInfo.frame, 0, 200);
			
					TestCircle(fScreen, 0,0,fScreen.width, fScreen.height);
					//Y2DEffectWipeFromTop(fScreen, scInfo.frame, 0, 200);
			
					TestEllipse(fScreen, 0,0,fScreen.width, fScreen.height);
					//Y2DEffectWipeFromBottom(fScreen, scInfo.frame, 0, 600);
					//Y2DEffectFadeToBlack(fScreen, 5);
			
				break;
		
				case 'l':	// Test Lines
					TestLine(fScreen, 0,0,fScreen.width, fScreen.height);
				break;
		
/*
				case 'q':	// Test Quadrilaterals
					TestQuad(fScreen, 0,0,fScreen.width, fScreen.height);
				break;
*/		
				case 'r':	// Test Rectangle
					TestRectangle(fScreen, 0,0,fScreen.width, fScreen.height);
				break;
/*		
				case 's':
					TestEffects(fScreen, 0,0,fScreen.width, fScreen.height);
				break;
*/		
				case 't':
					TestTriangle(fScreen, 0,0,fScreen.width, fScreen.height);
				break;

				default:
					// Do Nothing by default
				break;
		}
	}
}
#endif
