
#include "yagstest.h"

void
TestLine(pixel_buffer scrInfo, const U16 left, const U16 top,
	const U16 width, const U16 height)
{
	unsigned char aColor=0;
	float linesPerColor = height/256;
	U16 right = left + width - 1;
	U16 bottom = top + height - 1;
	U16 pointx[810];
	U16 pointy[810];
	float angle = 0.0;
	long counter;
		
	// Clear the area to black
	Y2DRectFill(scrInfo,left,top,right, bottom,0);
		

	// A bunch of random lines
	for (int i = 0; i < 10; i++)
	{
		for (int looper=0; looper < 800; looper++)
		{			
			U16 x1 = left + rand()%width;
			U16 y1 = top + rand()%height;
		
			U16 x2 = left + rand()%width;
			U16 y2 = top + rand()%height;
			
			Y2DLine(scrInfo, x1, y1, x2, y2, (looper)%256);
	
		}
	}

	// Do a radial clearing 
	int x1, x2;
	for (x1=left, x2 = right; x1 < right; x1++, x2--)
	{
		Y2DLine(scrInfo, x1, top, x2, bottom, 0);
	}
	
	int y1, y2;
	// Radial lines horizontally
	for (y1=top,y2=bottom; y1 < bottom; y1++,y2--)
	{
		Y2DLine(scrInfo, right, y1, left, y2, 0);
	}

	// Draw vertical lines
	for (counter = 0; counter < width; counter++)
	{
		Y2DVLine(scrInfo, left+counter, top, left+counter, bottom, 
			(U16)((float)counter / (float)((float)width/(float)256)));
	}
	
	// Draw horizontal lines
	for (counter = 0; counter < height/2; counter++)
	{
		Y2DHLine(scrInfo, left, counter+top, right, counter+top, 
			counter%256);
	}

	// Draw curved lines - top right
	for (counter = 0; counter < Y2DMIN(height,width); counter++)
	{
		Y2DLine(scrInfo, left+counter, top, 
			left+width, top+counter, 
			counter / linesPerColor);
	}

	// Draw curved lines - bottom left
	for (counter = 0; counter < Y2DMIN(height,width); counter++)
	{
		Y2DLine(scrInfo, left, top+counter, 
				left+counter, top+height, 
				counter / linesPerColor);
	}





	// Do some more spiral loops
	for (int looper = 0; looper<2; looper++)
	{
		// Radial lines vertically
		for (int x1=0; x1 < width; x1++)
		{
			U16 x2 = right-x1;
		
			Y2DLine(scrInfo, x1, 0, x2, bottom, 
				(x1*looper)%256);
		}
	
		// Radial lines horizontally
		for (int y1=0; y1 < height; y1++)
		{
			U16 y2 = height-y1-1;
		
			Y2DLine(scrInfo, 0, y1, right, y2, 
				(y1*looper)%256);
		}
	}
	
}

long
TestLineThread(void *data)
{
	testParam *tparam = (testParam*)data;
	
	TestLine(tparam->fScreenInfo, tparam->fFrame.left,tparam->fFrame.top,
		tparam->fFrame.Width(),tparam->fFrame.Height());
	
	return 0;
}

