#include "yagstest.h"

void
TestBitmap(screen_info scrInfo, const BRect frame)
{
	U16 height = frame.Height();
	U16 width = frame.Width();
	static screen_info * pixelBuffer=0;
	
	// Create a buffer to draw into
	if (!pixelBuffer)
		pixelBuffer = Y2DCreatePixelBuffer(200, 200);
	
	// Clear the screen to black
	Y2DRectFill(scrInfo,frame.left,frame.top,frame.right, frame.bottom,0);
	

	// do the line test into the buffer
	for (unsigned short counter = 0; 
		counter < 200; 
		counter++)
	{
		Y2DVLine(*pixelBuffer, counter, 0, counter, 199, 
			(U16)((float)counter / (float)((float)200/(float)256)));
	}
	
	// Blit the buffer to the screen
	Y2DCopyPixels(scrInfo, *pixelBuffer);
	
	
	// Destroy the pixel buffer
	//Y2DDestroyPixelBuffer(pixelBuffer);
}

long
TestBitmapThread(void *data)
{
	testParam *tparam = (testParam*)data;
	
	TestBitmap(tparam->fScreenInfo, tparam->fFrame);
	
	return 0;
}


