
#include "yagstest.h"
#include "yags3d.h"

static FacetedObject3D *
CreateObject()
{
	FacetedObject3D *newObject = new FacetedObject3D;
	
	newObject->fNumVertices = 4;
	newObject->fNumFaces = 1;
	newObject->fFaces[0].fNumVertices = 4;
	newObject->fFaces[0].fColor = 37;
	
	newObject->fFaces[0].fVertexList[0].x = -100;
	newObject->fFaces[0].fVertexList[0].y = -100;
	newObject->fFaces[0].fVertexList[0].z = 250;
	
	newObject->fFaces[0].fVertexList[1].x = 100;
	newObject->fFaces[0].fVertexList[1].y = -100;
	newObject->fFaces[0].fVertexList[1].z = 250;
	
	newObject->fFaces[0].fVertexList[2].x = 100;
	newObject->fFaces[0].fVertexList[2].y = 100;
	newObject->fFaces[0].fVertexList[2].z = 300;
	
	newObject->fFaces[0].fVertexList[3].x = -100;
	newObject->fFaces[0].fVertexList[3].y = 100;
	newObject->fFaces[0].fVertexList[3].z = 300;
	
	// Draw a single line
/*
	Point3Dhf pt1 = {-100,-100,250,1};
		Point3Dhf pt2 = {-100,150,250,1};
		Y3DLine(scrInfo, pt1, pt2, aColor, *aCamera);

		Point3Dhf pt3 = {100,-100,250,1};
		Point3Dhf pt4 = {100,150,250,1};
		Y3DLine(scrInfo, pt3, pt4, aColor, *aCamera);
		
		Point3Dhf pt5 = {-100,150,250,1};
		Point3Dhf pt6 = {100,150,250,1};
		Y3DLine(scrInfo, pt5, pt6, 32, *aCamera);
*/
	
	return newObject;
}

void
TestLine3D(pixel_buffer scrInfo,const U16 left, const U16 top,
	const U16 width, const U16 height)
{
	U08 aColor=57;
	U16 right = left + width -1;
	U16 bottom = top + height - 1;
	float linesPerColor = height/256;
	
	// Clear the area to black
	Y2DRectFill(scrInfo,left,top,right, bottom,0);
	
	// Create a camera
	Camera * aCamera = CreateCamera();
	FacetedObject3D *aObject = CreateObject();
	
	for (int counter = 0; counter < 100; counter ++)
	{
		Y2DRectFill(scrInfo,left,top,right, bottom,0);
		aCamera->viewing_distance += counter;
		
		Y3DRenderWireObject(scrInfo, aObject, 32, aCamera);
	}
	
	delete aObject;
}

long
TestLine3DThread(void *data)
{
	testParam *tparam = (testParam*)data;
	
	TestLine3D(tparam->fScreenInfo, tparam->fFrame.left,tparam->fFrame.top,
		tparam->fFrame.Width(),tparam->fFrame.Height());
	
	return 0;
}

