/***************************************************
**
**	File: wView.cpp
**	Description: 3d view constructor.
**	Copyright 1997, Be Incorporated
**
***************************************************/

#include "wView.h"

wView::wView(BRect r, char *n) : B3dView(n, r) {
}

#define  DEMO  6

#if (DEMO == 1)
//##################################################
// Getting something on the screen
//##################################################
void wView::AttachedToWindow() {
	B3dVector  v;
	RGBAColor  color;

	// need to call the inherited method
	inherited::AttachedToWindow();

	// need to lock the universe before modifying it
	Universe()->Lock();

	// create an ellipsoid.
	v.Set(2.0, 4.0, 4.0);
 	myBody = new B3dSphere("Test sphere", Universe(),
	                       &v, 500, B_FACE_MODEL);
	myBody->SetOrigin(10.0, 0.0, 0.0);

	// create lights
	color.Set(1.0, 1.0, 1.0, 0.0);
	v.Set(2.0, 4.0, 3.0);
	new B3dParallelLight("Test Light1", Universe(),
	                     0.8, &color, &v);
 	new B3dAmbientLight("Test Light2",Universe(),
	                    0.3, &color);

	// turn the camera to look at the ellipsoid
	Camera()->ViewPoint()->LookAt(myBody);

	// end of universe modification
	Universe()->Unlock();	
}

wView::~wView() {
}

#elif (DEMO == 2)
//##################################################
// Using links.
//##################################################
void wView::AttachedToWindow() {
	B3dVector  v;
	RGBAColor  color;

	inherited::AttachedToWindow();

	Universe()->Lock();

	// create an ellipsoid
	v.Set(1.0, 2.0, 2.0);
 	myBody = new B3dSphere("Test sphere", Universe(),
	                       &v, 500, B_SMOOTH_MODEL);
	myBody->SetOrigin(10.0, 0.0, -2.0);
	// link the body around the vertical axis
	v.Set(0.0, 0.0, 1.0);
	myBody->LinkTo(new B3dAxisLink(0.7, &v));

	// create a cube
	v.Set(1.0, 1.0, 1.0);
 	sndBody = new B3dCube("cube", Universe(), &v);
	sndBody->SetOrigin(7.0, 0.0, -2.0);
	// link the cube in orbit around the ellipsoid
	v.Set(0.0, 0.0, 1.0);
	sndBody->LinkTo(new B3dOrbitLink(0.5,
									 myBody, &v));

	// create a sphere
	v.Set(0.5, 0.5, 0.5);
 	trdBody = new B3dSphere("sphere", Universe(),
							&v, 125, B_SMOOTH_MODEL);
	trdBody->SetOrigin(7.0, 0.0, -0.7);
	// link the sphere in orbit around the cube
	v.Set(1.0, 1.0, 0.0);
	trdBody->LinkTo(new B3dOrbitLink(3.2,
									 sndBody, &v));

	// add an ambient light
	color.Set(1.0, 1.0, 1.0, 0.0);
 	new B3dAmbientLight("Test Light2",
	                    Universe(), 0.3, &color);

	// add a red light and its link
	color.Set(1.0, 0.0, 0.0, 0.0);
	Light = new B3dParallelLight("Test Light1",
	                             Universe(),
	                             0.8, &color, &v);
	Light->LinkTo(new B3dJigLink(1.2, -0.5, 0.9));
	// add a green light and its link
	color.Set(0.0, 1.0, 0.0, 0.0);
	Light = new B3dParallelLight("Test Light1",
	                             Universe(),
	                             0.8, &color, &v);
	Light->LinkTo(new B3dJigLink(-0.2, 1.0, -0.5));
	// add a blue light
	color.Set(0.0, 0.0, 1.0, 0.0);
	Light = new B3dParallelLight("Test Light1",
	                             Universe(),
	                             0.8, &color, &v);
	Light->LinkTo(new B3dJigLink(1.0, 1.7, 0.4));
	
	Camera()->ViewPoint()->LookAt(myBody);

	Universe()->Unlock();	
}

wView::~wView() {
}

#elif (DEMO == 3)
//##################################################
// Using level of detail.
//##################################################
void wView::AttachedToWindow() {
	int        i;
	B3dThing   *list[3];
	B3dVector  v;
	RGBAColor  color;

	// need to call the inherited method
	inherited::AttachedToWindow();

	// need to lock the universe before modifying it
	Universe()->Lock();

	// create a cube
	v.Set(0.5, 0.5, 0.5);
 	myBody = new B3dCube("cube", Universe(), &v);
	myBody->SetOrigin(5.0, 1.2, -1.3);

	// create a simple sphere
	v.Set(2.0, 2.0, 2.0);
 	sndBody = new B3dSphere("sphere500", Universe(),
							&v, 500, B_SMOOTH_MODEL);
	// enhanced it into a 3 level LOD sphere
	trdBody = new B3dSphere("sphere100", Universe(),
							&v, 100, B_SMOOTH_MODEL);
	trdBody->TieThing(sndBody, 60);
	sndBody = new B3dSphere("sphere20", Universe(),
							&v, 20, B_SMOOTH_MODEL);
	sndBody->TieThing(trdBody, 15);
	sndBody->SetOrigin(8.0, 0.0, -3.0);

	// clone another sphere
	trdBody = sndBody->Clone();
	trdBody->SetOrigin(14.0, 0.0, -3.0);

	// clone the 248 other spheres
	v.Set(0.0, 0.0, 1.0);
	list[0] = sndBody;
	list[1] = trdBody;
 	for (i=2; i<250; i++) {
		list[2] = sndBody->Clone();
		list[2]->SetOrigin(8.0+6.0*i, 0.0, -3.0);
		list[2]->LinkTo(new wLink(list[1],
								  list[0],
								  myBody, &v));
		list[0] = list[1];
		list[1] = list[2];
	}

	// create lights
	color.Set(1.0, 1.0, 1.0, 0.0);
	v.Set(2.0, 4.0, 3.0);
	new B3dParallelLight("Test Light1", Universe(),
	                     0.8, &color, &v);
 	new B3dAmbientLight("Test Light2",Universe(),
	                    0.3, &color);

	// turn the camera to look at the second sphere
	v.Set(14.0, 0.0, -3.0);
	Camera()->ViewPoint()->LookAt(trdBody);

	// end of universe modification
	Universe()->Unlock();	
}

wView::~wView() {
}

#elif (DEMO == 4)
//##################################################
// User inter-action.
//##################################################
void wView::AttachedToWindow() {
	B3dVector  v;
	RGBAColor  color;

	inherited::AttachedToWindow();

	Universe()->Lock();

	// create a cube
	v.Set(2.0, 4.0, 4.0);
 	myBody = new wCube("Cube", Universe(), &v);
	myBody->SetOrigin(14.0, 0.0, 0.0);

	// create lights
	color.Set(1.0, 1.0, 1.0, 0.0);
	v.Set(2.0, 4.0, 3.0);
	new B3dParallelLight("Test Light1", Universe(),
	                     0.8, &color, &v);
 	new B3dAmbientLight("Test Light2",Universe(),
	                    0.3, &color);

	// turn the camera to look at the box
	Camera()->ViewPoint()->LookAt(myBody);

	Universe()->Unlock();	
}

wView::~wView() {
}

#elif (DEMO == 5)
//##################################################
// Importing models.
//##################################################
void wView::AttachedToWindow() {
	B3dVector        v;
	RGBAColor        color;
	B3dFaceEditor    *fe;
	
	inherited::AttachedToWindow();
	Universe()->Lock();

	// create a teapot model from a text file
 	fe = new B3dFaceEditor("/boot/3dDemo/Model",
	                       B_GH_TYPE);
	// make it red
	color.Set(1.0, 0.2, 0.2, 0.0);
	fe->SetFaceColor(&color, B_ALL_FACES);
	// get the teapot object
 	myBody = fe->CurrentFace("teapot", Universe());
	// we don't need that FaceEditor anymore
	delete fe;

	v.Set(0.0, 0.0, 1.0);
	myBody->SetOrigin(10.0, 2.0, -4.0);
	myBody->LinkTo(new B3dAxisLink(0.5, &v));

	color.Set(1.0, 1.0, 1.0, 0.0);
 	new B3dAmbientLight("Test Light2",
	                    Universe(), 0.3, &color);
	Light = new B3dParallelLight("Test Light1",
	                             Universe(),
	                             0.8, &color, &v);
	Light->LinkTo(new B3dJigLink(1.0, 1.7, 0.4));
	
	Camera()->ViewPoint()->LookAt(myBody);

	Universe()->Unlock();	
}

wView::~wView() {
	delete offView;
	delete pict;
}

#elif (DEMO == 6)
//##################################################
// Just a little trick...
//##################################################
void wView::AttachedToWindow() {
	B3dVector        v;
	B3dAxisLink      *link;
	B3dFaceEditor    *fe;
	B3dRadialOptions *opt_ptr;
	
	inherited::AttachedToWindow();

	Universe()->Lock();

	// load a picture 256x256 as a graphic channel
	pict = new B3dBitmap(
	       LoadTiff("/boot/3dDemo/Image"),Universe());

	// create a teapot model from a text file
 	fe = new B3dFaceEditor("/boot/3dDemo/Model",
	                       B_GH_TYPE);
	// set environment mapping for all faces
	fe->SetFaceMirror(B_ALL_FACES, pict, 0.715);
	// get the teapot object
 	myBody = fe->CurrentFace("Big teapot", Universe());
	// we don't need that FaceEditor anymore
	delete fe;
	// put that first teapot in place
	myBody->SetOrigin(8.0, 6.0, -5.0);
	v.Set(0.0, 0.0, 1.0);
	myBody->LinkTo(new B3dAxisLink(0.4, &v));

	// create a 3d offscreen channel, using the
	// previous graphic channel as an offscreen
	offView = new B3dOffView("fake", pict->Frame(),
							 Universe(), pict);
	// clone the first teapot
	sndBody = myBody->Clone("Small teapot");
	// create a FaceEditor to change its look
	fe = new B3dFaceEditor((B3dFace*)sndBody);
	fe->SetFaceMirror(B_ALL_FACES, offView, 0.67);
	sndBody = fe->CurrentFace("Small teapot",
	                          Universe());
	delete fe;
	
	// put that first teapot in place
	sndBody->SetOrigin(12.4, 15.7, -6.75);
	sndBody->LinkTo(new B3dAxisLink(-0.71, &v));

	// turn the camera to look between the 2 teapots
	v.Set(8.0, 7.1, -4.8);
	Camera()->ViewPoint()->LookAt(&v);

	// put the camera of the offscreen channel just
	// in front of the second teapot
	v.Set(12.3, 15.6, -6.6);
	offView->Camera()->SetViewPoint(v);
	// turn this camera to look between the first
	// teapot and the first camera
	v.Set(7.0, 5.1, -3.8);
	offView->Camera()->ViewPoint()->LookAt(&v);
	// set this camera to use a wide angle
	offView->Camera()->Lens()->GetOptions(&opt_ptr);
	opt_ptr->zoom = 240.0;
	offView->Camera()->Lens()->SetOptions();
	
	// end of universe modification
	Universe()->Unlock();	
}

wView::~wView() {
	delete offView;
	delete pict;
}
#endif






