/***************************************************
**
**	File: wCube.cpp
**	Description: 3d cube constructor.
**	Copyright 1997, Be Incorporated
**
***************************************************/

#ifndef  _W_CUBE_H_
#include <wCube.h>
#endif
#ifndef _3D_CAMERA_H
#include "3dCamera.h"
#endif

/* trivial constructor */
wCube::wCube(char *name,
			 B3dUniverse *uni,
			 B3dVector *size)
: B3dCube(name, uni, size) {
// keep a copy of the size of the cube, and
// reduce it, a little smaller than half,
// for corner and edge detection
	box = (*size) * 0.4;
}

/* first cursor touch */
void wCube::TouchDown(B3dTouchDesc *touch,
					   int32        x,
					   int32        y,
					   uint32       buttons) {
	int         count;
	B3dVector   v;

	inherited::TouchDown(touch, x, y, buttons);

// detect which contact area is used
	v = touch->touch0;
	count = 0;
	if ((v.x > box.x) || (-v.x > box.x))
		count++;
	if ((v.y > box.y) || (-v.y > box.y))
		count++;
	if ((v.z > box.z) || (-v.z > box.z))
		count++;
// near the corners
	if (count == 3)
		mode = W_TURN;
// near the edges
	else if (count == 2)
		mode = W_Z_MOVE;
// somewhere else...
	else
		mode = W_XY_MOVE;
}

/* cursor draging */
void wCube::TouchMoved(B3dTouchDesc *t,
					   int32        x,
					   int32        y,
					   uint32       buttons,
					   B3dCamera    *camera) {
	float          dx, dy, dz, scale;
	B3dVector      v;
	B3dMatrix      rot, rot1;

	switch (mode) {
// turning the object
	case W_TURN :
		inherited::TouchMoved(t, x, y, buttons,
							  camera);
		return;
// draging parallel to the plane of the screen
	case W_Z_MOVE :
		if (y < 0) y = 0;
		dz = t->view_origin.z *
		  ((float)(t->y0+1)/(float)(y+1)-1.0);
		v = t->origin0 +
			t->view_referential.Z() * dz;
		SetOrigin(&v);
		break;
// changing the depth
	case W_XY_MOVE :
		scale = t->view_origin.z/t->zoom_factor;
		dx = (x-t->x0)*scale;
		dy = (y-t->y0)*scale;
		v = t->origin0 +
		    t->view_referential.X() * dx +
		    t->view_referential.Y() * dy;
		SetOrigin(&v);
		break;
	}
// unselect the object at the end
	if (!buttons)
		highlightColor.Set(0.0, 0.0, 0.0, 1.0);	
}








