/*
 * Copyright (C) 1997 Be, Inc.  All Rights Reserved
 */
#include <NetDevice.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <OS.h>
#include <byteorder.h>
#include "netdump.h"

static FILE *f;
static short just_started;

void
NetdumpController::AddDevice(
							BNetDevice *dev, 
							const char *name
							)
{
	if (dev->Type() != B_ETHER_NET_DEVICE)
		return;

	f = fopen(DUMPTO, "w+");
	if (!f) return;

	just_started = true;
	register_packet_handler(this, dev, NETDUMP_PRIO);
}

bool 
NetdumpController::PacketReceived(
								 BNetPacket *pkt,
								 BNetDevice *dev
								 )
{
    static double time0;
	static ulong pktn;
	ushort pkt_size, i;
	uchar mac_addr[MAC_ADDR_LEN];
	char protostr[12];
	ushort protoid;

    if (just_started) {
	    just_started = false;
	    pktn = 0;
		time0 = system_time();
    }

	if (pktn++ == MAX_PKT_N) {	// There! Now close and cleanup
		unregister_packet_handler(this, dev);
		fclose(f);
		// From now on, only counter will get incremented. No output.
	}
	if (pktn >= MAX_PKT_N)		// are we there yet?
		return false;
	// else...

	pkt_size = pkt->Size();

    fprintf(f, "Frame# %u, Length=%d, ", pktn, pkt_size);
	fprintf(f, "deltaTime=%10.4f, ", (system_time() - time0) / 1000);

	// PID/len
	pkt->Read(ETHDR_PROTOID_OFS, (char *)&protoid, sizeof(protoid));
	protoid = B_BENDIAN_TO_HOST_INT16(protoid);  // net is big-endian
	// interpret it
	if (protoid > MAX_ETH_LEN) {
	  switch (protoid) {
	  case PROTOID_IP:
		strcpy(protostr, "IP");
		break;
	  case PROTOID_ARP:
		strcpy(protostr, "ARP");
		break;
	  case PROTOID_RARP:
		strcpy(protostr, "RARP");
		break;
	  case PROTOID_APLTK:
		strcpy(protostr, "AppleTalk");
		break;
	  default:
		strcpy(protostr, "#Unknown#");
		break;
	  }
	  fprintf(f, "Protocol=%s, ", protostr);
	} // else // This is IEEE 802.3 len. See RFC 894, 1042...

	// frame destination
	fprintf(f, "PID=0x%04x\nDst=[", protoid);
	pkt->Read(0, (char *) &mac_addr, MAC_ADDR_LEN);
	for (i = 0; i < MAC_ADDR_LEN; i++)
	    fprintf(f, "%02x%s", (uchar) mac_addr[i], 
				(i == MAC_ADDR_LEN -1) ? "], " : ":");

	// ...and source
	fprintf(f, "Src=[");
	pkt->Read(MAC_ADDR_LEN, (char *) &mac_addr, MAC_ADDR_LEN);
	for (i = 0; i < MAC_ADDR_LEN; i++)
	    fprintf(f, "%02x%s", (uchar) mac_addr[i],
				(i == MAC_ADDR_LEN -1) ? "], " : ":");

	fprintf(f, "Entire frame follows");
	for (i = 0; i < pkt_size; i++) {
	    fprintf(f, "%s%02x", (i % 0x10) == 0 ? "\n\t" : " ",
				(uchar) (pkt->Data())[i]);
	}
    fprintf(f, "\n"); fflush(f);
	time0 = system_time();		// there's always next time()
    return false;				// let others enjoy this frame, too
}

#pragma export on
extern "C" BNetProtocol *
open_protocol(
			  const char *device
			  )
{
	NetdumpController *dev;

	dev = new NetdumpController();
	return (dev);
}
#pragma export reset




