// BTSServerSocket.h
/* A BTSServerSocket allows you to create a fully-configured
   socket object, ready to accept clients, in a single call.
   The necessary parameters are passed to the constructor. The
   validity of the construction can be checked by calling 
   InitCheck(). 
*/

#pragma once
#ifndef _B_SERVERSOCKET_
#define _B_SERVERSOCKET_

#include "BTSSocket.h"

#pragma export on

class BTSServerSocket:public BTSSocket
{
	public:
						BTSServerSocket(const unsigned short port, 
								const int maxConnections, 
								const uint32 address = INADDR_ANY,
								const int type = SOCK_STREAM, 
								const int protocol = IPPROTO_TCP, 
								const int family = AF_INET );
		virtual bool	InitCheck();
	private:
		BTSAddress		mAddress;
	
};

#pragma export reset
#endif