
#include "BTSServerSocket.h"

// =============================================================================
//     BTSServerSocket
// =============================================================================
BTSServerSocket::BTSServerSocket(const unsigned short port, 
								const int maxConnections, 
								const uint32 address,
								const int type , 
								const int protocol, 
								const int family) :
								BTSSocket(type, protocol, family), 
								mAddress(port, address, family) 
{
	long result;
	if (ID() >= 0)
	if ((result = BindTo(mAddress)) == B_NO_ERROR)
	{
		result = Listen(maxConnections);
	}
	return;
}

// =============================================================================
//     InitCheck
// =============================================================================
bool
BTSServerSocket::InitCheck()
{
	return inherited::InitCheck() && IsBound() && IsListening();
}