// =============================================================================
//     BTSServerMonitor.cpp
// =============================================================================
#include "BTSServerMonitor.h"
#include <interface/StringView.h>
#include <app/Application.h>
#include <stdio.h>

const BRect kMonitorDlogRect(100,200,250, 300);
const BRect kConnectionTextFrame (30, 10, 145, 20);
const BRect kUseLoopbackCheckFrame(30,30,130,40);
const BRect kPrefCancelButtonFrame(30, 70, 75, 80);
const BRect kStartServingButtonFrame(85, 70, 145, 80);


// Message stuff
const char* USE_LOOPBACK = "Loopback";

// =============================================================================
//     BTSServerMonitor
// =============================================================================
BTSServerMonitor::BTSServerMonitor(const char* title):
	BWindow(kMonitorDlogRect, title, B_TITLED_WINDOW, 
		B_NOT_MINIMIZABLE|B_NOT_RESIZABLE)
{
	Lock();	
	fCancelButton = new BButton(kPrefCancelButtonFrame, "Cancel", "Cancel",
		new BMessage(SERVER_CANCEL_MSG));
	AddChild(fCancelButton);

	fStartServingButton = new BButton(kStartServingButtonFrame, "Start", "Start",
		new BMessage(START_SERVING_MSG));
	AddChild(fStartServingButton);
	
	fConnectionsString = new BStringView(kConnectionTextFrame, "Connections", 
								"Connections:0");
	AddChild(fConnectionsString);
	
	fUseLoopbackCheck = new BCheckBox(kUseLoopbackCheckFrame, "Use Loopback", 
								"Use Loopback", 0, B_WILL_DRAW);
	fUseLoopbackCheck->SetValue(1);
	
	AddChild(fUseLoopbackCheck);
				
	SetDefaultButton(fStartServingButton);	
	Unlock();
	fNumConnections = 0;
	return;
}


// =============================================================================
//     MessageReceived
// =============================================================================
void 
BTSServerMonitor::MessageReceived(BMessage* inMessage)
{
	switch (inMessage->what)
	{
		case SERVER_CANCEL_MSG:	
				be_app->PostMessage(B_QUIT_REQUESTED);
				QuitRequested();
		break;
		
		case START_SERVING_MSG:
			{
				int value = fUseLoopbackCheck->Value();
				BMessage* startMessage = new BMessage(START_SERVING_MSG);
				
				startMessage->AddBool(USE_LOOPBACK, (value > 0));
				be_app->PostMessage(startMessage);
				fStartServingButton->SetEnabled(FALSE);
				fUseLoopbackCheck->SetEnabled(FALSE);
			}
		break;
		
		default:
			BWindow::MessageReceived(inMessage);
		break;
	}
	return;
}

// =============================================================================
//     AddClient
// =============================================================================
void 
BTSServerMonitor::AddClient()
{
	char numConnections[100];
	sprintf(numConnections, "Connections: %d", ++fNumConnections);
	Lock();
	fConnectionsString->SetText(numConnections);
	Unlock();
	return;
}

// =============================================================================
//     RemoveClient
// =============================================================================
void 
BTSServerMonitor::RemoveClient()
{
	char numConnections[100];
	sprintf(numConnections, "Connections: %d", --fNumConnections);
	Lock();
	fConnectionsString->SetText(numConnections);
	Unlock();
	return;
}

// =============================================================================
//     QuitRequested
// =============================================================================
bool 
BTSServerMonitor::QuitRequested()
{
	BWindow::QuitRequested();
	
	be_app->PostMessage(B_QUIT_REQUESTED);
	return(TRUE);
}

