// BTSClientSocket.cpp
/* A client socket allows for creation of a socket connection
   to a server. The necessary parameters needed to create the
   connection are passed to the constructor. The constructor 
   will block until either a connection has been made or the
   attempt has failed. The InitCheck() function should be used
   after construction to ensure the connection is valid.
   
*/
#include "BTSClientSocket.h"

// =============================================================================
//    • BTSClientSocket
// =============================================================================
BTSClientSocket::BTSClientSocket(const unsigned short port, 
									const char* serverHostName, 
									const int type , 
									const int protocol, 
									const int family) :
									BTSSocket(type, protocol, family),
									mAddress(port, serverHostName, family) 
{
	ConnectToAddress(mAddress);
	return;
}

// =============================================================================
//    • BTSClientSocket
// =============================================================================
bool
BTSClientSocket::InitCheck()
{
	return inherited::InitCheck() && IsConnected();
}			