//#define DEBUG 1
// =============================================================================
//     BTSAddress.cpp
// =============================================================================

#include <string.h>
#include <netdb.h>
#include <socket.h>
#include <Debug.h>
#include "BTSAddress.h"


// =============================================================================
//     BTSAddress
// =============================================================================
BTSAddress::BTSAddress(const unsigned short port, 
						const unsigned long address, 
						const int family)
{
	// Define the connection information.
	fAddr.sin_family = family;
	fAddr.sin_port = htons(port);	//htons gives portability.
	fAddr.sin_addr.s_addr = address;
	::memset(fAddr.sin_zero, 0, sizeof(fAddr.sin_zero));
	fHostName = NULL;
	return;
}

// =============================================================================
//     BTSAddress
// =============================================================================
BTSAddress::BTSAddress(const unsigned short port, const char* hostName, 
						const int family )
{
	PRINT(("BTSAddress::BTSAddress - ENTER\n"));
	// Define the connection information.
	PRINT(("BTSAddress::BTSAddres - getting host entry for %s\n", hostName));
	struct hostent* host = gethostbyname(hostName);
	if (host != NULL)
	{
		PRINT(("BTSAddress::BTSAddres - setting up sockaddr\n"));
		fAddr.sin_addr.s_addr = *(unsigned long*)(host->h_addr);
		fAddr.sin_family = family;
		fAddr.sin_port = htons(port);	//htons gives portability.
	}
	::memset(fAddr.sin_zero, 0, sizeof(fAddr.sin_zero));
	fHostName = hostName;
	PRINT(("BTSAddress::BTSAddress - EXIT\n"));
	
	return;
}

// =============================================================================
//     SockAddr
// =============================================================================
const sockaddr_in*	
BTSAddress::SockAddr() const
{
	return &fAddr;
}

// =============================================================================
//     HostEntry
// =============================================================================
hostent*	
BTSAddress::HostEntry() const
{
	struct hostent* entry = NULL;
	if (fHostName != NULL)
	{
		entry = ::gethostbyname(fHostName);	// Convert host name to ip addr

	}
	else if (fAddr.sin_addr.s_addr != 0)
	{
		//entry = gethostbyaddr(fAddr.sin_addr.s_addr);
	}
	return entry;
}