// =============================================================================
//     BTSNetDrawClient.h
// =============================================================================
// Implements a simple client. Puts up a dialog that allows the user
// to select a host to connect to. Once connected, it displays a 
// window that can be drawn in with the mouse. Drawing commands are
// sent to the server and received from other clients and drawn in
// the window.

#ifndef _B_BTSNetDrawClient
#define _B_BTSNetDrawClient

#include <app/Application.h>

#include "BTSNetDrawWindow.h"
#include "BTSPrefDlog.h"
#include "BTSNetMsgClient.h"

// Thread names.
extern char* kRequestHandlerName;
extern char* kNetDrawClientName;

class BTSNetDrawClient:public BApplication
{
	public:
	
							BTSNetDrawClient();
		virtual void		SetHostName(const char* inName);
		virtual char*		GetHostName();
		virtual void 		MessageReceived(BMessage* inMessage);
		virtual void		ReadyToRun();
	private:
	
		char*				fHostName;
		BTSNetDrawWindow* 	fDrawWindow;
		BTSPrefDlog*		fPrefDlog;
		BTSNetMsgClient*	fClient;
		BBitmap*			fBitmap;
		BView*				fView;
		bool				fExiting;

		virtual	bool	QuitRequested();
};


#endif