// =============================================================================
//     BTSChatServer.cpp
// =============================================================================
#include <stdio.h>
#include <string.h>
#include <Bitmap.h>
#include <View.h>
#include <support/Debug.h>

#include "BTSServerMonitor.h"
#include "BTSNetMsgServer.h"
#include "BTSChatServer.h"
#include "BTSChatConstants.h"

BRect kChatWindowRect(100,200,300,400);
const char* kMonitorTitle = "Chat Server";

main()
{	
	BTSChatServer *myApplication;

	myApplication = new BTSChatServer();
	
	myApplication->Run();
	
	delete(myApplication);
	return(0);
}

// =============================================================================
//     BTSChatServer
// =============================================================================
BTSChatServer::BTSChatServer(): BApplication('NTDW')
{
	kChatWindowRect.OffsetTo(B_ORIGIN);
	// #define DEBUG to 1 and turn this on for debugging.
	//_setDebugFlag(TRUE);
	fBitmap = new BBitmap(kChatWindowRect, B_MONOCHROME_1_BIT, TRUE);
	fView = new BView(kChatWindowRect, "OffView", 0, B_NOT_RESIZABLE);	
	fBitmap->AddChild(fView);
	fServer = NULL;
	return;
}



// =============================================================================
//     ReadyToRun
// =============================================================================
void 
BTSChatServer::ReadyToRun()
{
	fMonitor = new BTSServerMonitor(kMonitorTitle);
	fMonitor->Show();
	return;
}

// =============================================================================
//     QuitRequested
// =============================================================================
bool
BTSChatServer::QuitRequested()
{
	if (fServer)
	{
		fServer->PostMessage(B_QUIT_REQUESTED);
	}
	return TRUE;
}

// =============================================================================
//     MessageReceived
// =============================================================================
void 
BTSChatServer::MessageReceived(BMessage* inMessage)
{
	PRINT(("BTSChatServer::MessageReceived - ENTER\n"));
	switch (inMessage->what)
	{		
		case CHAT_MSG:
			PRINT(("BTSChatServer - chat message start\n"));
			DetachCurrentMessage();
			fServer->PostMessage(inMessage);
			PRINT(("BTSChatServer - chat message done\n"));
		break;
		
		case NEW_CLIENT_MSG:
				fMonitor->AddClient();
		break;
		
		case DEAD_CONNECTION_MSG:
			fMonitor->RemoveClient();
		break;
		
		case START_SERVING_MSG:
			{
				bool useLoopback = inMessage->FindBool(USE_LOOPBACK);
				StartServing(useLoopback);
			}
		break;
		
		default:
			BApplication::MessageReceived(inMessage);
		break;
	}
	return;
	PRINT( ("BTSChatServer::MessageReceived - ENTER\n"));
}



// =============================================================================
//     StartServing
// =============================================================================
void 
BTSChatServer::StartServing(bool useLoopback)
{
	if (!useLoopback)
	{
		fServer = new BTSNetMsgServer(kCHATPORT);
	}
	else
	{
		fServer = new BTSNetMsgServer(kCHATPORT, this, B_URGENT_PRIORITY,
										MAX_CONNECTIONS, INADDR_LOOPBACK);
	}
	fServer->Run();
	return;
}