//#define DEBUG 1
#include <stdio.h>
#include <string.h>
#include <AppKit.h>
#include <InterfaceKit.h>
#include <support/Debug.h>

#include "BTSChatWindow.h"
#include "BTSPrefDlog.h"
#include "BTSChatClient.h"
#include "BTSChatConstants.h"

main()
{	
	BTSChatClient *myApplication;

	myApplication = new BTSChatClient();
	
	// Once everything is setup, start running the application.
	myApplication->Run();
	
	delete(myApplication);
	return(0);
}

// =============================================================================
//     BTSChatClient
// =============================================================================
BTSChatClient::BTSChatClient(): BApplication('NTCL')
{	
	fExiting = FALSE;
	fHostName = NULL;
	fChatWindow = NULL;
	fPrefDlog = NULL;
	fClient = NULL;
	return;
}

// =============================================================================
//     SetHostName
// =============================================================================
void	
BTSChatClient::SetHostName(const char* inName)
{
	fHostName = strdup(inName);
}

// =============================================================================
//     GetHostName
// =============================================================================
const char* 	
BTSChatClient::GetHostName() const
{
	return fHostName;
}

// =============================================================================
//     QuitRequested
// =============================================================================
bool 	
BTSChatClient::QuitRequested()
{
	PRINT(("App quit requested\n"));
	fExiting = TRUE;
	if (fClient)
	{	
		fClient->Quit();
		fClient = NULL;
	}
	PRINT(("Posting message to window\n"));
	if (fChatWindow)
	{
		fChatWindow->PostMessage(QUIT_CHAT_WINDOW_MSG);
	}
	return BApplication::QuitRequested();
}


// =============================================================================
//     MessageReceived
// =============================================================================
void 
BTSChatClient::MessageReceived(BMessage* inMessage)
{
	PRINT(("BTSChatClient::MessageReceived - ENTER\n"));

	switch (inMessage->what)
	{
		case QUIT_CHAT_WINDOW_MSG:
			fExiting = TRUE;
			PostMessage(B_QUIT_REQUESTED);
		break;
		
		case PREFS_ACCEPTED_MSG:
			if (inMessage->HasString(HOST_NAME))
			{
				const char* hostName = inMessage->FindString(HOST_NAME);
				SetHostName(hostName);
				fClient = new BTSNetMsgClient(kCHATPORT, fHostName);
				if (!fClient->Run())
				{
					PostMessage(B_QUIT_REQUESTED);
				}
				else
				{
					fChatWindow = new BTSChatWindow(kChatClientName);
					fChatWindow->Show();
					fPrefDlog->Close();			
				}
			}
		break;
		
		case CHAT_MSG:
			PRINT(("Got message for window\n"));
			
			if (!fExiting)
			{
				DetachCurrentMessage();
				fChatWindow->PostMessage(inMessage);
				if (!(inMessage->HasPointer(SOURCE_SOCKET)) && !(fClient->IsExiting()))
				{
					//It's a locally-generated message.
					PRINT(("Sending local message out\n"));
					BMessage *newMessage = new BMessage(inMessage);
					fClient->PostMessage(newMessage);
				}
			}
		break;
			
		case DEAD_CONNECTION_MSG:
			PostMessage(B_QUIT_REQUESTED);
		break;
		
		default:
			BApplication::MessageReceived(inMessage);
		break;
	}
	PRINT(("BTSChatClient::MessageReceived - EXIT\n"));
	return;
}


// =============================================================================
//     ReadyToRun
// =============================================================================
void 
BTSChatClient::ReadyToRun()
{
	fPrefDlog = new BTSPrefDlog();
	fPrefDlog->Show();
	return;
}


