// =============================================================================
//  BTSPrefDlog.cpp
// =============================================================================
// Displays a dialog for a network client that allows
// the user to specify the host that he wants to connect
// to.
#include <app/Application.h>
#include <stdio.h>
#include <support/Debug.h>
#include <string.h>

#include "BTSPrefDlog.h"

const BRect 		kPrefDlogRect(100,200,250, 300);
const char* 		kPrefDlogTitle = "Connection Prefs";
const BRect			kPrefOKButtonFrame(90, 70, 140, 85);
const BRect 		kPrefCancelButtonFrame(30, 70, 80, 85);
const BRect			kPrefHostNameFrame(5, 0, 145, 20);
const BRect			kPrefConnectTextFrame(30, 30, 100,50);

char *HOST_NAME = "Host Name";

// =============================================================================
//     BTSPrefDlog
// =============================================================================
BTSPrefDlog::BTSPrefDlog():
	BWindow(kPrefDlogRect, kPrefDlogTitle, B_TITLED_WINDOW, 
		B_NOT_MINIMIZABLE|B_NOT_RESIZABLE)
{

	
	Lock();	
	fOKButton = new BButton(kPrefOKButtonFrame, "Connect", "Connect", 
							new BMessage(PREF_OK_MSG));
	AddChild(fOKButton);
	
	fCancelButton = new BButton(kPrefCancelButtonFrame, "Cancel", "Cancel",
							new BMessage(PREF_CANCEL_MSG));
	AddChild(fCancelButton);
	
	fHostNameField = new BTextControl(kPrefHostNameFrame, "HostName",
								"Host Name:", "127.0.0.1", NULL);
	AddChild(fHostNameField);
	
	fConnectText= new BStringView(kPrefConnectTextFrame, "Connecting", 
								"Connecting...", 0 , B_WILL_DRAW);
	AddChild(fConnectText);
	fConnectText->Hide();
	
	fHostNameField->MakeFocus(TRUE);
	
	SetDefaultButton(fOKButton);
	Unlock();
	return;
}


// =============================================================================
//     QuitRequested
// =============================================================================
bool 
BTSPrefDlog::QuitRequested()
{
	// Need to tell the app to quit if the dialog is exited without hitting
	// 'OK'
	PRINT("Quitting pref dialog (and app)\n");
	
	BWindow::QuitRequested();
	be_app->PostMessage(B_QUIT_REQUESTED);
	return(TRUE);
}

// =============================================================================
//     MessageReceived
// =============================================================================
void 
BTSPrefDlog::MessageReceived(BMessage* inMessage)
{
	PRINT("Pref dlogreceived message.\n");
	
	switch (inMessage->what)
	{
		case PREF_OK_MSG:
			// The user has selected a host.
			const char* hostName = fHostNameField->Text();
			if (hostName != NULL)
			{
				if (strcmp(hostName, ""))
				{
					BMessage* prefAcceptMessage = 
										new BMessage(PREFS_ACCEPTED_MSG);
					prefAcceptMessage->AddString(HOST_NAME, 
											fHostNameField->Text());
					be_app->PostMessage(prefAcceptMessage);

					fOKButton->SetEnabled(FALSE);
					fConnectText->Show();
				}
			}
		break;
				
		break;
		
		case PREF_CANCEL_MSG:
			// User has cancelled.
			PostMessage(B_QUIT_REQUESTED);
		break;

		default:
			BWindow::MessageReceived(inMessage);
		break;
	}
	return;
}