// =============================================================================
//     BTSNetMsgServer.h
// =============================================================================
/*	Defines a "message server" that communicates with clients by converting
	BMessages to and from network data. The server acts by taking messages that
	are posted to it and either repeating them to all connected clients
	or to a specified target client. The server also has an associated
	BLooper that is the message receiver. Any messages received from clients
	are posted to this message receiver.
*/
#ifndef _B_BTSNETMSGSERVER_
#define _B_BTSNETMSGSERVER_

#include <net/socket.h>
#include "BTSSocket.h"
#include "BTSNetMsgUtils.h"

#define MAX_CONN 20

// Server message stuff.
#define NEW_CLIENT_MSG 'NUCL'
#define DEAD_CONNECTION_MSG 'DDCT'

extern const char* TARGET_SOCKET;


// =============================================================================
class BTSNetMsgServer: public BLooper
{
	public:	
									BTSNetMsgServer(const unsigned short port, 
										BLooper* messageReceiver = NULL,
										const long priority = B_URGENT_PRIORITY,
										const int maxConnections = MAX_CONN,
										const unsigned long address = INADDR_ANY,
										const int family = AF_INET, 
										const int type = SOCK_STREAM,
										const int protocol = IPPROTO_TCP);
									~BTSNetMsgServer();
		// Member accessors
		virtual BTSSocket&			Socket() { return fSocket;};
		virtual sem_id 				SocketListSem() { return fSocketListSem;};
		virtual BList* 				SocketList() {return &fClientSocketList;};
;
		virtual BLooper*			MessageReceiver() 
										{return fMessageReceiver;};
;
		virtual bool				IsExiting() {return fIsExiting;};
;
		virtual int 				ClientCount() {
										return fClientSocketList.CountItems();};
;		
		// Other
		virtual thread_id			Run();
		virtual long				SendToClients(BMessage* message);

	private:
	
		BList 						fClientSocketList;
		const BTSAddress			fAddress;	// Socket address
 		BLooper*					fMessageReceiver;

		thread_id					fConnectionRequestHandlerID;
		thread_id					fClientListenerID;

 		const long					fPriority;	// Thread priority
		sem_id						fSocketListSem;
		
		BTSSocket					fSocket;	// Accept socket

		const int					fMaxConnections;

		bool						fIsExiting;	
		
		virtual void				AddClient(BTSSocket* socket);
		virtual bool				RemoveClient(BTSSocket* socket);
		virtual void				MessageReceived(BMessage* inMessage);
		virtual bool 				QuitRequested();

		static long					HandleConnectionRequests(void* arg);		
		static long					ListenToClients(void* arg);
};

#endif