#include <stdio.h>
#include <string.h>
#include <Bitmap.h>
#include <View.h>
#include <support/Debug.h>

#include "BTSServerMonitor.h"
#include "BTSNetMsgServer.h"
#include "BTSNetDrawServer.h"
#include "BTSNetDrawMsgDefs.h"

main()
{	
	BTSNetDrawServer *myApplication;

	myApplication = new BTSNetDrawServer();
	
	// Once everything is setup, start running the application.
	myApplication->Run();
	
	delete(myApplication);
	return(0);
}

// =============================================================================
//     BTSNetDrawServer
// =============================================================================
BTSNetDrawServer::BTSNetDrawServer(): BApplication('NTDW')
{
	BRect drawWindowRect(100,200,300,400);
	drawWindowRect.OffsetTo(B_ORIGIN);
	
	// Turn this on and set DEBUG to see debug output.
	//_setDebugFlag(TRUE);
	fBitmap = new BBitmap(drawWindowRect, B_MONOCHROME_1_BIT, TRUE);
	fView = new BView(drawWindowRect, "OffView", 0, B_NOT_RESIZABLE);	
	fBitmap->AddChild(fView);
	fServer = NULL;
	return;
}



// =============================================================================
//     ReadyToRun
// =============================================================================
void 
BTSNetDrawServer::ReadyToRun()
{
	BRect	monitorWindowSize(100,200,250,300);
	fMonitor = new BTSServerMonitor(monitorWindowSize);
	fMonitor->Show();
	return;
}

// =============================================================================
//     QuitRequested
// =============================================================================
bool
BTSNetDrawServer::QuitRequested()
{
	if (fServer)
	{
		fServer->PostMessage(B_QUIT_REQUESTED);
	}
	return TRUE;
}

// =============================================================================
//     MessageReceived
// =============================================================================
void 
BTSNetDrawServer::MessageReceived(BMessage* inMessage)
{
	PRINT(("BTSNetDrawServer::MessageReceived - ENTER\n"));
	switch (inMessage->what)
	{		
		case NETDRAWLINE_MSG:
			PRINT(("BTSNetDrawServer - net line message start\n"));
			if (inMessage->HasPoint("LineStart") && inMessage->HasPoint("LineEnd"))
			{
				BPoint 	startPoint = inMessage->FindPoint("LineStart");
				BPoint 	endPoint = inMessage->FindPoint("LineEnd");
				
				fBitmap->Lock();
				fView->MovePenTo(startPoint.x, startPoint.y);
				fView->StrokeLine(endPoint);
				fView->Sync();	
				fBitmap->Unlock();
							
				// Send it to all the other clients.
				DetachCurrentMessage();
				fServer->PostMessage(inMessage);	
				PRINT(("BTSNetDrawServer - net line message done\n"));
			}	
		break;
		
		case NEW_CLIENT_MSG:
			BTSSocket* socket;
			if (inMessage->HasObject(SOURCE_SOCKET))
			{
				socket = (BTSSocket*)inMessage->FindObject(SOURCE_SOCKET);
				// Send a message to the client's handler that contains
				// the current bitmap.
				BMessage 	*message = new BMessage(BITMAP_DATA_MSG);
				if (message != NULL)
				{
					long 		bitmapSize = fBitmap->BitsLength();
					void* 		bitmapData = fBitmap->Bits();
					if (message->Error() == B_NO_ERROR)
					{
						message->AddData("Bitmap", B_RAW_TYPE, bitmapData, bitmapSize);
						if (message->Error() == B_NO_ERROR)
						{
							message->AddObject(TARGET_SOCKET, (BObject*)socket);
							if (message->Error() == B_NO_ERROR)
							{
								fServer->PostMessage(message);
							}
							else delete message;
						}
						else delete message;
					}
					else delete message;
				}
				fMonitor->AddClient();
			}
		break;
		
		case CLEAR_MSG:
			void* buf = fBitmap->Bits();
			long numBytes = fBitmap->BitsLength();
			memset(buf, 0, numBytes);
			fBitmap->Lock();
			fBitmap->SetBits(buf, numBytes, 0, B_MONOCHROME_1_BIT);
			//fView->Sync();
			fBitmap->Unlock();

			// Send it to all the other clients.
			DetachCurrentMessage();
			fServer->PostMessage(inMessage);			
		break;
		
		case DEAD_CONNECTION_MSG:
			fMonitor->RemoveClient();
		break;
		
		case START_SERVING_MSG:
			{
				bool useLoopback = inMessage->FindBool(USE_LOOPBACK);
				StartServing(useLoopback);
			}
		break;
		
		default:
			BApplication::MessageReceived(inMessage);
		break;
	}
	return;
	PRINT( ("BTSNetDrawServer::MessageReceived - ENTER\n"));
}



// =============================================================================
//     StartServing
// =============================================================================
void 
BTSNetDrawServer::StartServing(bool useLoopback)
{
	if (!useLoopback)
	{
		fServer = new BTSNetMsgServer(kNETDRAWPORT);
	}
	else
	{
		fServer = new BTSNetMsgServer(kNETDRAWPORT, this, B_URGENT_PRIORITY,
										MAX_CONNECTIONS, INADDR_LOOPBACK);
	}
	fServer->Run();
	return;
}