// =============================================================================
//     BTSDrawView.cpp
// =============================================================================
// A view that implements MouseMoved() and generates draw messages as long as
// the mouse button is down.

#include <stdio.h>
#include <app/Message.h>
#include <app/Application.h>
#include <support/Debug.h>

#include "BTSNetDrawMsgDefs.h"
#include "BTSDrawView.h"

// =============================================================================
//     BTSDrawView
// =============================================================================
BTSDrawView::BTSDrawView(BRect frame, BBitmap* bitmap) : BView(frame, "NetDraw", 
			B_FULL_UPDATE_ON_RESIZE, B_FOLLOW_ALL_SIDES | B_WILL_DRAW) 
{
	fBitmap = bitmap;
	fExiting = FALSE;
	return;
}

// =============================================================================
//     MouseDown
// =============================================================================
void
BTSDrawView::MouseDown(BPoint where)
{
	SetLineStart(where);
	return;
}


// =============================================================================
//     MouseMoved
// =============================================================================
void
BTSDrawView::MouseMoved(BPoint where, ulong code,
									BMessage *a_message)
{
	ulong 	buttons;
	BRect 	range;
	PRINT(("BTSDrawView::MouseMoved - ENTER\n"));
	
	if (Window()->Lock())
	{
	buttons = Window()->CurrentMessage()->FindLong("buttons");
	if (buttons)
	{						
		if (code != B_ENTERED_VIEW )
		{
			BRect		lineRect;
			BMessage* 	drawMsg = new BMessage(NETDRAWLINE_MSG);
			
			if (drawMsg != NULL)
			{
				drawMsg->AddPoint("LineStart", fLastPoint);
				if (drawMsg->Error() == B_NO_ERROR)
				{
					drawMsg->AddPoint("LineEnd", where);
					if (drawMsg->Error() == B_NO_ERROR)
					{
						be_app->PostMessage(drawMsg);
					}
					else delete drawMsg;
				}
				else delete drawMsg;
			}
		}
		SetLineStart(where);
	}
	}
	Window()->Unlock();
	PRINT(("BTSDrawView::MouseMoved - EXIT\n"));
	return;
}

// =============================================================================
//     Draw
// =============================================================================
void
BTSDrawView::Draw(BRect updateRect)
{
	PRINT(("BTSDrawView::Draw - ENTER\n"));
	DrawBitmap(fBitmap, updateRect, updateRect);
	PRINT(("BTSDrawView::Draw - EXIT\n"));
	return;
}

// =============================================================================
//     SetLineStart
// =============================================================================
void 
BTSDrawView::SetLineStart(BPoint startPoint)
{
	fLastPoint = startPoint;
	return;
}

// =============================================================================
//     IsExiting
// =============================================================================
bool
BTSDrawView::IsExiting()
{
	return fExiting;
}

// =============================================================================
//     SetExiting
// =============================================================================
void
BTSDrawView::SetExiting(bool value)
{
	fExiting = value;
}
