#include "BTSChatMonitor.cpp"
#include <interface/StringView.h>
#include <app/Application.h>
#include <stdio.h>

const BRect 		kPrefDlogRect(100,200,300, 300);
const char* 		kPrefDlogTitle = "Connection Prefs";

// =============================================================================
//     BTSChatMonitor
// =============================================================================
BTSChatMonitor::BTSChatMonitor(BRect size):
	BWindow(size, kMonitorTitle, B_TITLED_WINDOW, 
		B_NOT_MINIMIZABLE|B_NOT_RESIZABLE)
{
	BRect connectionTextFrame (30, 10, 145, 20);
	BRect fUseLoopbackCheckFrame(30,30,130,40);
	BRect prefCancelButtonFrame(30, 70, 75, 80);
	BRect fStartServingButtonFrame(85, 70, 145, 80);
	
	Lock();	
	fCancelButton = new BButton(prefCancelButtonFrame, "Cancel", "Cancel",
		new BMessage(SERVER_CANCEL_MSG));
	AddChild(fCancelButton);

	fStartServingButton = new BButton(fStartServingButtonFrame, "Start", "Start",
		new BMessage(START_SERVING_MSG));
	AddChild(fStartServingButton);
	
	fConnectionsString = new BStringView(connectionTextFrame, "Connections", 
								"Connections:0");
	AddChild(fConnectionsString);
	
	fUseLoopbackCheck = new BCheckBox(fUseLoopbackCheckFrame, "Use Loopback", 
								"Use Loopback", 0, B_WILL_DRAW);
	fUseLoopbackCheck->SetValue(1);
	
	AddChild(fUseLoopbackCheck);
				
	SetDefaultButton(fStartServingButton);	
	Unlock();
	fNumConnections = 0;
	return;
}


// =============================================================================
//     MessageReceived
// =============================================================================
void 
BTSChatMonitor::MessageReceived(BMessage* inMessage)
{
	switch (inMessage->what)
	{
		case SERVER_CANCEL_MSG:	
				be_app->PostMessage(B_QUIT_REQUESTED);
				QuitRequested();
		break;
		
		case START_SERVING_MSG:
			{
				int value = fUseLoopbackCheck->Value();
				BMessage* startMessage = new BMessage(START_SERVING_MSG);
				
				startMessage->AddBool(USE_LOOPBACK, (value > 0));
				be_app->PostMessage(startMessage);
				fStartServingButton->SetEnabled(FALSE);
				fUseLoopbackCheck->SetEnabled(FALSE);
			}
		break;
		
		default:
			BWindow::MessageReceived(inMessage);
		break;
	}
	return;
}

// =============================================================================
//     AddClient
// =============================================================================
void 
BTSChatMonitor::AddClient()
{
	char numConnections[100];
	sprintf(numConnections, "Connections: %d", ++fNumConnections);
	Lock();
	fConnectionsString->SetText(numConnections);
	Unlock();
	return;
}

// =============================================================================
//     RemoveClient
// =============================================================================
void 
BTSChatMonitor::RemoveClient()
{
	char numConnections[100];
	sprintf(numConnections, "Connections: %d", --fNumConnections);
	Lock();
	fConnectionsString->SetText(numConnections);
	Unlock();
	return;
}

// =============================================================================
//     QuitRequested
// =============================================================================
bool 
BTSChatMonitor::QuitRequested()
{
	BWindow::QuitRequested();
	
	be_app->PostMessage(B_QUIT_REQUESTED);
	return(TRUE);
}

