#include "BTSBorderTextView.h"
#include <interface/TextView.h>

// =============================================================================
//     BTSBorderTextView
// =============================================================================
BTSBorderTextView::BTSBorderTextView(BRect frame,const char *name,
								BRect textRect, ulong resizeMask,
								ulong flags) : BTextView(frame, name,
								textRect, resizeMask, flags)
{
	return;
}

// =============================================================================
//     Draw
// =============================================================================
void
BTSBorderTextView::Draw(BRect rect)
{
	BRect theRect = Bounds();
	theRect.left -= 1;
	theRect.right += 1;
	theRect.top -= 1;
	theRect.bottom +=1;
	BTextView::Draw(rect);
	StrokeRect(Bounds());
}

// =============================================================================
//     KeyDown
// =============================================================================
void BTSBorderTextView::KeyDown(ulong aChar)
{
	Invalidate(Bounds());
	BTextView::KeyDown(aChar);
}

// =============================================================================
//     Insert
// =============================================================================
void BTSBorderTextView::Insert(const char* text)
{
	Invalidate(Bounds());
	BTextView::Insert(text);
}