// Copyright 2000, Be Incorporated. All Rights Reserved.
// This file may be used under the terms of the Be Sample Code License.

#ifndef _DIRWALKER_H
#define _DIRWALKER_H

#include <Entry.h>
#include <List.h>

class DirWalker
{
	private:
		entry_ref rootref;	// where it all starts
		BList reflist;		// list of all entry_refs under the root
		BList dirlist;		// directories I've already been
		
		status_t AddEntries(const entry_ref *ref);
		bool IsInDirList(const entry_ref *ref);
		
		int32 index;

	public:
		DirWalker(const entry_ref &ref);
		DirWalker(const char *path);
		virtual ~DirWalker();

		void Rewind();
		status_t NextRef(entry_ref *nextref);
};

#endif
