#include "MotorMix.h"
#include "ChannelView.h"

#include <CheckBox.h>
#include <Debug.h>
#include <Messenger.h>
#include <MidiConsumer.h>
#include <MidiProducer.h>
#include <MidiRoster.h>
#include <Slider.h>
#include <stdio.h>
#include <string.h>
#include <Window.h>

class TestApp : public BApplication
{
public:
	TestApp();

virtual void ReadyToRun();
virtual void MessageReceived(BMessage *msg);

	BWindow		*mWindow;
	MotorMix 	*mMotorMix;
	ChannelView	**mChannels;
	int32		mChannelCount;
};


TestApp::TestApp() :
	BApplication("application/x-vnd.Be-MotorMixTest"),
	mMotorMix(NULL),
	mChannels(NULL),
	mChannelCount(8),
	mWindow(NULL)
{
}

void 
TestApp::ReadyToRun()
{
	/* creat the motor mix */
	mMotorMix = new MotorMix("MotorMix");
	mMotorMix->SetMessenger(new BMessenger(this));
	mMotorMix->SetChannelCount(mChannelCount);
	/* find the midi port */
	PRINT(("looking for midi producers\n"));
	int32 id = 0;
	BMidiProducer *producer;
	while ((producer = BMidiRoster::NextProducer(&id))) {
		if (!strcmp(producer->Name(), "midi/sonic_vibes/1")) {
			printf("Found producer\n");
			break;
		}
	}
	PRINT(("looking for midi consumers\n"));
	id = 0;
	BMidiConsumer *consumer;
	while ((consumer = BMidiRoster::NextConsumer(&id))) {
		if (!strcmp(consumer->Name(), "midi/sonic_vibes/1")) {
			printf("Found consumer\n");
			break;
		}
	}
	/* tell the MotorMix where the device is connected */
	PRINT(("add the device\n"));
	mMotorMix->AddDevice("SonicVibes1", 1, producer, consumer, mMotorMix);
	/* create the window */
	PRINT(("creating window\n"));
	BRect r(100, 100, 600, 500);
	mWindow = new BWindow(r, "MotorMix", B_TITLED_WINDOW, B_WILL_ACCEPT_FIRST_CLICK|B_ASYNCHRONOUS_CONTROLS);
	mWindow->Show();
	r = mWindow->Bounds();
	r.left += 10;
	r.right = r.left + 60;
	mChannels = new ChannelView *[mChannelCount];
	for (int i=0; i < mChannelCount; i++) {
		mChannels[i] = new ChannelView(i, mMotorMix, r);
		mWindow->AddChild(mChannels[i]);
		r.OffsetBy(60, 0);
	}
}

void 
TestApp::MessageReceived(BMessage *msg)
{
	int32 channel;
	if (msg->FindInt32("channel", &channel) < B_OK || channel >= mChannelCount)
		return;
	int16 value;
	if (msg->FindInt16("value", &value) < B_OK)
		return;
	int64 time;
	if(msg->FindInt64("time", &time) < B_OK)
		return;
	switch (msg->what) {
		case MM_SELECT_MSG:
			if (mWindow->Lock()) {
				mChannels[channel]->mSelect->SetValue(mMotorMix->GetSelect(channel));
				mWindow->Unlock();
			}
			break;	
		case MM_BYPASS_MSG:
			if (mWindow->Lock()) {
				mChannels[channel]->mBypass->SetValue(mMotorMix->GetBypass(channel));
				mWindow->Unlock();
			}
			break;	
		case MM_RECORD_MSG:
			if (mWindow->Lock()) {
				mChannels[channel]->mRecord->SetValue(mMotorMix->GetRecord(channel));
				mWindow->Unlock();
			}
			break;	
		case MM_SOLO_MSG:
			if (mWindow->Lock()) {
				mChannels[channel]->mSolo->SetValue(mMotorMix->GetSolo(channel));
				mWindow->Unlock();
			}
			break;	
		case MM_MUTE_MSG:
			if (mWindow->Lock()) {
				mChannels[channel]->mMute->SetValue(mMotorMix->GetMute(channel));
				mWindow->Unlock();
			}
			break;	
		case MM_FADER_MOVED_MSG:
		//	PRINT(("MM_FADER_MOVED %ld %d %Ld\n", channel, value, time));
			if (mWindow->Lock()) {
				mChannels[channel]->mSlider->SetValue(value);
				mWindow->Unlock();
			}
			break;
		default:
			break;
	}
}


int
main()
{
	TestApp app;
	app.Run();
	return 1;
}
