#ifndef MOTOR_MIX_H
#define MOTOR_MIX_H

#include <StorageDefs.h>
#include <SupportDefs.h>

#define MOTOR_MIX_NAME_LENGTH 32

/* motor mix messages */
#define MM_SELECT_MSG 		'mmsc'	/* int32 channel, int16 state, int64 time */
#define MM_BYPASS_MSG 		'mmbp'	/* int32 channel, int16 state, int64 time */
#define MM_RECORD_MSG 		'mmrc'	/* int32 channel, int16 state, int64 time */
#define MM_SOLO_MSG 		'mmso'	/* int32 channel, int16 state, int64 time */
#define MM_MUTE_MSG 		'mmmt'	/* int32 channel, int16 state, int64 time */
#define MM_FADER_TOUCH_MSG 	'mmft'	/* int32 channel, int16 state, int64 time */
#define MM_FADER_MOVED_MSG 	'mmfm'	/* int32 channel, int16 value, int64 time */

#define MMFADER_MIN 0x0000
#define MMFADER_MAX	0x3fff
#define MMKNOB_MIN 0x0000
#define MMKNOB_MAX	0x3fff

#define MMCHANNEL_COUNT 8

enum light_state {
	MM_OFF		= 0x00,
	MM_ON 		= 0x40,
	MM_BLINK	= 0x50
};

enum switch_state {
	MM_PRESS	= 0x40,
	MM_RELEASE	= 0x00
};

const char kMMHeader[8] = {0xf0, 0x00, 0x01, 0x0f, 0x00, 0x11, 0x00, 0x00};

class MotorMixProducer;
class MotorMixConsumer;
struct MotorMixChannel;
struct MotorMixDevice;

class MotorMix
{
public:
				MotorMix(const char *name);
		virtual	~MotorMix();
	
		status_t	Init();

/* device managment */
		int32		AddDevice(const char *name, uchar midiChannel,
							BMidiProducer *input, BMidiConsumer *output,
							MotorMix *motormix);
		void 		RemoveDevice(int32 device_id);
		int32		CurrentChannelFor(int32 device_id);
		void		SetCurrentChannelFor(int32 device_id, int32 channel);
		void		SetAllFor(int32 device_id);		/* sets all to current */
		void		ResetAllFor(int32 device_id);	/* resets all to 0 or off */
		
/* state managment */
		int32			CountChannels();
		void			SetChannelCount(int32 count);

		void			SetTitle(int32 channel, const char *title);
		void			SetSelect(int32 channel, light_state state);
		void			SetBypass(int32 channel, light_state state);
		void			SetRecord(int32 channel, light_state state);
		void			SetSolo(int32 channel, light_state state);
		void			SetMute(int32 channel, light_state state);
		void			SetFader(int32 channel, int16 value);	/* 0 to 1 */
		
		const char 		*GetTitle(int32 channel);
		light_state		GetSelect(int32 channel, bigtime_t *last = NULL);
		light_state		GetBypass(int32 channel, bigtime_t *last = NULL);
		light_state		GetRecord(int32 channel, bigtime_t *last = NULL);
		light_state		GetSolo(int32 channel, bigtime_t *last = NULL);
		light_state		GetMute(int32 channel, bigtime_t *last = NULL);
		int16			GetFader(int32 channel, bigtime_t *last = NULL);	/* 0 to 1 */
		
/* notification */
		void	SetMessenger(BMessenger *messenger);	/* set to receive changes via BMessage */
		void	SetStateStorage(bool on);		/* set to have state stored, on by default */
/* default behavior is to store state send a message */
virtual void 	Selected(int32 device_id, int32 channel, switch_state state, bigtime_t time);
virtual void 	Bypassed(int32 device_id, int32 channel, switch_state state, bigtime_t time);
virtual void 	Recorded(int32 device_id, int32 channel, switch_state state, bigtime_t time);
virtual void 	Soloed(int32 device_id, int32 channel, switch_state state, bigtime_t time);
virtual void 	Muted(int32 device_id, int32 channel, switch_state state, bigtime_t time);
virtual void 	FaderMoved(int32 device_id, int32 channel, int16 value, bigtime_t time);	/* 0 to 1 */

private:
		void	SetChannelLED(int32 channel, uchar lsb);
		void	SetFunctionLED(uchar msb, uchar lsb);

		void 	SetControlFor(int32 device_id, uchar msb, uchar lsb);

		void 	RecallSettings();
		void 	SaveSettings();
		
		char				*mName;
		BMidiRoster 		*mRoster;
		MotorMixDevice 		*mDevices;
		MotorMixChannel		*mChannels;
		int32				mDeviceIDs;
		int32				mDeviceCount;
		int32				mChannelCount;
		int32				mCurrentChannel;
		BMessenger			*mMessenger;
		bool				mStoreState;
	
};

#endif MOTOR_MIX_H