#include "MMProducer.h"
#include "MMDevice.h"
#include <Debug.h>

#define FUNCTION PRINT

/* MotorMixProducer */
MotorMixProducer::MotorMixProducer(const char *name, MotorMixDevice *device) :
	BMidiLocalProducer(name),
	mDevice(device)
{
}

MotorMixProducer::~MotorMixProducer()
{
}

void 
MotorMixProducer::Connected(BMidiConsumer *dest)
{
	FUNCTION(("MotorMix::Connected 0x%x\n", dest));
	mDevice->Connected();
}

void 
MotorMixProducer::Disconnected(BMidiConsumer *dest)
{
	FUNCTION(("MotorMix::Disconnected 0x%x\n", dest));
	mDevice->Disconnected();
}
