#ifndef MMDEVICE_H
#define MMDEVICE_H

#include "MotorMix.h"
#include <OS.h>

struct MotorMixChannel
{
	char			mTitle[MOTOR_MIX_NAME_LENGTH];
	int32			mID;
	light_state		mSelect;
	light_state		mBypass;
	light_state		mRecord;
	light_state		mSolo;
	light_state		mMute;
	int16			mFader;
};

class MotorMix;
class MotorMixProducer;
class MotorMixConsumer;

class MotorMixDevice
{
public:
		MotorMixDevice(const char *name,
						int32 id,
						uchar channel,
						BMidiProducer *input,
						BMidiConsumer *output,
						MotorMix *motormix);
		~MotorMixDevice();
	
		status_t			InitCheck();
		const char 			*Name() { return mName; };
		int32			 	ID() { return mID; };
		uchar				MidiChannel() { return mMidiChannel; };
		int32				CurrentChannel() { return mCurrentChannel; };
		void				SetCurrentChannel(int32 channel) { mCurrentChannel = channel; };
		MotorMixProducer 	*Producer() { return mProducer; };
		MotorMixConsumer 	*Consumer() { return mConsumer; };
		MotorMixDevice		*NextDevice() { return mNext; };
	
		bool 		ChannelIsVisible(int32 channel);
		void		SetControl(uchar control, uchar msb, uchar lsb);
		
		void		ControlChange(uchar control, uchar msb, uchar lsb, bigtime_t time);
		void		ControlChange(uchar control, uchar value, bigtime_t time);

		void		Connected();
		void		Disconnected();		
		
		void		PingResponse();
		void		NoResponse();
private:
	friend class MotorMix;
		
		void		KeepAlive();
static 	status_t	KeepAliveEntry(void *dev);
	
	char 				*mName;
	int32 				mID;
	uchar				mMidiChannel;
	int32				mCurrentChannel;
	thread_id			mThread;
	sem_id				mSemaphore;
	bool				mKeepAlive;
	bool				mDetected;
	BMidiProducer		*mInput;
	BMidiConsumer		*mOutput;
	MotorMixProducer 	*mProducer;
	MotorMixConsumer 	*mConsumer;
	MotorMix			*mMotorMix;
	MotorMixDevice 		*mNext;
};

#endif