#ifndef MMCONSUMER_H
#define MMCONSUMER_H

#include "MotorMix.h"
#include <MidiConsumer.h>

enum {
	FADER 	= 0x0,
	SELECT 	= 0x1,
	MUTE	= 0x2,
	SOLO	= 0x3,
	BYPASS	= 0x4,
	RECORD	= 0x5
};

class MMDevice;

class MotorMixConsumer : public BMidiLocalConsumer
{
public:
	MotorMixConsumer(const char *name, uchar midiChannel, MotorMixDevice *device);
	~MotorMixConsumer();

	/* from MidiLocalConsumer */

/* shouldn't need to override this for MotorMix
	but if you want to do parsing yourself... */
#if 0
	virtual void Data(uchar *data, size_t length, bool atomic,
					  bigtime_t time = B_NOW);	
#endif
	virtual	void NoteOff(uchar channel, uchar note, uchar velocity, 
						 bigtime_t time);
	virtual	void NoteOn(uchar channel, uchar note, uchar velocity, 
						bigtime_t time);
	virtual	void KeyPressure(uchar channel, uchar note, uchar pressure, 
							 bigtime_t time);
	virtual	void ControlChange(uchar channel, uchar controlNumber, 
							   uchar controlValue, 
							   bigtime_t time);
	virtual	void ProgramChange(uchar channel, uchar programNumber, 
							   bigtime_t time);
	virtual	void ChannelPressure(uchar channel, uchar pressure, 
								 bigtime_t time);
	virtual	void PitchBend(uchar channel, uchar lsb, uchar msb, 
						   bigtime_t time);
	virtual	void SystemExclusive(void* data, size_t dataLength, 
								 bigtime_t time);
	virtual	void SystemCommon(uchar statusByte, uchar data1, uchar data2, 
							  bigtime_t time);
	virtual	void SystemRealTime(uchar statusByte, 
								bigtime_t time);
	virtual	void TempoChange(int32 bpm, 
							 bigtime_t time);
	virtual void AllNotesOff(bool justChannel, 
							 bigtime_t time);

private:
	MotorMixDevice 	*mDevice;
	uchar			mMidiChannel;
	bool			mControlChangeInProgress;
	uchar			mControlChangeControl;
	uchar			mControlChangeValue;
	bigtime_t 		mControlChangeTime;
};

#endif