#include "MMConsumer.h"
#include "MMDevice.h"
#include "MotorMix.h"
#include <Debug.h>

#define FUNCTION PRINT

/* MotorMixConsumer */
MotorMixConsumer::MotorMixConsumer(const char *name, uchar midiChannel, MotorMixDevice *device) :
	BMidiLocalConsumer(name),
	mMidiChannel(midiChannel),
	mDevice(device)
{
}

MotorMixConsumer::~MotorMixConsumer()
{
}

void
MotorMixConsumer::NoteOff(uchar channel, uchar note, uchar velocity, bigtime_t time)
{
	FUNCTION(("MotorMixConsumer::NoteOff\n"));
}

void 
MotorMixConsumer::NoteOn(uchar channel, uchar note, uchar velocity, bigtime_t time)
{
/*
	if (channel != mMidiChannel)
		return;
*/
	if (note == 0 && velocity == 0x7f) {
	//	FUNCTION(("MotorMixConsumer::NoteOn ping back\n"));
		mDevice->PingResponse();
	}
}

void 
MotorMixConsumer::KeyPressure(uchar channel, uchar note, uchar pressure, bigtime_t time)
{
	FUNCTION(("MotorMixConsumer::KeyPressure\n"));
}

void 
MotorMixConsumer::ControlChange(uchar channel, uchar controlNumber, uchar controlValue, bigtime_t time)
{
	//FUNCTION(("MotorMixConsumer::ControlChange 0x%x 0x%x 0x%x\n", channel, controlNumber, controlValue));
/*	if (channel != mMidiChannel)
		return;	/* ignore */
	if (!mControlChangeInProgress && (controlNumber < 0x08 || controlNumber == 0x0F)) {
		mControlChangeControl = controlNumber;
		mControlChangeValue = controlValue;
		mControlChangeTime = time;
		mControlChangeInProgress = true;
	} else if(mControlChangeInProgress) {
		mControlChangeInProgress = false;
		if (controlNumber - 0x20 != mControlChangeControl)
			return; /* no match */
		mDevice->ControlChange(mControlChangeControl, mControlChangeValue, controlValue, mControlChangeTime);
	} else {
		mDevice->ControlChange(controlNumber, controlValue, 0, time);
	}
}

void 
MotorMixConsumer::ProgramChange(uchar channel, uchar programNumber, bigtime_t time)
{
	FUNCTION(("MotorMixConsumer::ProgramChange\n"));
}

void 
MotorMixConsumer::ChannelPressure(uchar channel, uchar pressure, bigtime_t time)
{
	FUNCTION(("MotorMixConsumer::ChannelPressure\n"));
}

void 
MotorMixConsumer::PitchBend(uchar channel, uchar lsb, uchar msb, bigtime_t time)
{
	FUNCTION(("MotorMixConsumer::PitchBend\n"));
}

void 
MotorMixConsumer::SystemExclusive(void *data, size_t dataLength, bigtime_t time)
{
	FUNCTION(("MotorMixConsumer::SystemExclusive\n"));
}

void 
MotorMixConsumer::SystemCommon(uchar statusByte, uchar data1, uchar data2, bigtime_t time)
{
	FUNCTION(("MotorMixConsumer::SystemCommon\n"));
}

void 
MotorMixConsumer::SystemRealTime(uchar statusByte, bigtime_t time)
{
	FUNCTION(("MotorMixConsumer::SystemCommon\n"));
}

void 
MotorMixConsumer::TempoChange(int32 bpm, bigtime_t time)
{
	FUNCTION(("MotorMixConsumer::TempoChange\n"));
}

void 
MotorMixConsumer::AllNotesOff(bool justChannel, bigtime_t time)
{
	FUNCTION(("MotorMixConsumer::AllNotesOff\n"));
}

