#include "ChannelView.h"
#include "MotorMix.h"
#include <CheckBox.h>
#include <Slider.h>
#include <stdio.h>
#include <Window.h>

ChannelView::ChannelView(int32 id, MotorMix *motormix, BRect frame) :
	BView(frame, "channel", B_FOLLOW_TOP|B_FOLLOW_LEFT,
			B_WILL_DRAW),
	mSelect(NULL),
	mKnob(NULL),
	mBypass(NULL),
	mRecord(NULL),
	mSolo(NULL),
	mMute(NULL),
	mSlider(NULL),
	mID(id),
	mMotorMix(motormix)
{
	BMessage *msg;
	BRect r = Bounds();
	/* select */
	r.bottom = r.top + 20;
	msg = new BMessage(SELECT_MSG);
	mSelect = new BCheckBox(r, "select", "select", msg);
	AddChild(mSelect);
	r.OffsetBy(0, 20);
	/* knob */
	r.bottom = r.top + 30;
	msg = new BMessage(KNOB_MSG);
	mKnob = new BSlider(r, "knob", "pan", msg, MMKNOB_MIN, MMKNOB_MAX);
	AddChild(mKnob);	
	r.OffsetBy(0, 30);
	/* bypass */
	r.bottom = r.top + 20;
	msg = new BMessage(BYPASS_MSG);
	mBypass = new BCheckBox(r, "bypass", "bypass", msg);
	AddChild(mBypass);
	r.OffsetBy(0, 20);
	/* record */
	r.bottom = r.top + 20;
	msg = new BMessage(RECORD_MSG);
	mRecord = new BCheckBox(r, "record", "record", msg);
	AddChild(mRecord);
	r.OffsetBy(0, 20);
	/* solo */
	r.bottom = r.top + 20;
	msg = new BMessage(SOLO_MSG);
	mSolo = new BCheckBox(r, "solo", "solo", msg);
	AddChild(mSolo);
	r.OffsetBy(0, 20);
	/* mute */
	r.bottom = r.top + 20;
	msg = new BMessage(MUTE_MSG);
	mMute = new BCheckBox(r, "mute", "mute", msg);
	AddChild(mMute);
	r.OffsetBy(0, 20);
	/* slider */
	r.bottom = Bounds().bottom;
	msg = new BMessage(SLIDER_MSG);
	char name[8];
	sprintf(name, "gain %d", mID+1);
	mSlider = new BSlider(r, "slider", name, msg, MMFADER_MIN, MMFADER_MAX, B_VERTICAL);
	msg = new BMessage(SLIDER_MSG);
	mSlider->SetModificationMessage(msg);
	AddChild(mSlider);
}


ChannelView::~ChannelView()
{
}

void 
ChannelView::AllAttached()
{
	if (Window()->Lock()) {
		mSelect->SetTarget(this);
		mKnob->SetTarget(this);
		mBypass->SetTarget(this);
		mRecord->SetTarget(this);
		mSolo->SetTarget(this);
		mMute->SetTarget(this);
		mSlider->SetTarget(this);
		Window()->Unlock();
	}
}

void 
ChannelView::MessageReceived(BMessage *msg)
{
	//msg->PrintToStream();
	light_state state = MM_OFF;
	switch (msg->what) {
		case SELECT_MSG:
			if (mSelect->Value())
				state = MM_ON;
			mMotorMix->SetSelect(mID, state);
		case KNOB_MSG:
			break;
		case BYPASS_MSG:
			if (mBypass->Value())
				state = MM_ON;
			mMotorMix->SetBypass(mID, state);
			break;
		case RECORD_MSG:
			if (mRecord->Value())
				state = MM_ON;
			mMotorMix->SetRecord(mID, state);
			break;			
		case SOLO_MSG:
			if (mSolo->Value())
				state = MM_ON;
			mMotorMix->SetSolo(mID, state);
			break;
		case MUTE_MSG:
			if (mMute->Value())
				state = MM_ON;
			mMotorMix->SetMute(mID, state);
			break;
		case SLIDER_MSG: {
			int16 value	= (int16)(mSlider->Value());
			mMotorMix->SetFader(mID, value);
			break;
		}
	}
}