////////////////////////////////////////////////////////////////////////////////
// Whistler.h
// ----------
// Whistler is the core event processing of the Whistle application.
// It generates MIDI events from keyboard and mouse input events.
//
// Copyright 1999, Be Incorporated. All Rights Reserved.
// This file may be used under the terms of the Be Sample Code License.

#ifndef WHISTLER
#define WHISTLER

#include <Screen.h>
#include <MidiSynth.h>
#include <OS.h>
#include <Handler.h>

typedef struct {
	float x;
	float y;
	int32 item;
} input_info;


class Whistler : public BHandler
{
	public:
	Whistler();
	~Whistler();
	
	void Enable(bool);

	void Go(void);
	virtual void MessageReceived(BMessage *msg);
	void ReckonScreen(void);
	void ToggleMouseInst(bool isDown);
	void SetPan(int32 pan);
	
	void Play(int32 code, input_info *ii);
	void PlayMouseMusic(void);

	void NoteOn(int32 which, int32 note, int32 vol);
	void NoteOff(int32 which);

	void SetMouseVol(float value);
	void SetButtonsVol(float value);
	void SetKeyboardVol(float value);
	
	private:

	enum {
		KEYBOARD,
		MOUSE_MOVE_BASS_1,
		MOUSE_MOVE_BASS_2,
		MOUSE_MOVE_COMP_1,
		MOUSE_MOVE_COMP_2,
		MOUSE_MOVE_COMP_3,
		MOUSE_MOVE_COMP_4,
		MOUSE_DOWN,
		MOUSE_UP,
		NOTE_COUNT
	};
		
	enum {
		KEYBOARD_CHAN = 10,
		MOUSE_MOVE_BASS_1_CHAN = 1,
		MOUSE_MOVE_BASS_2_CHAN = 2,
		MOUSE_MOVE_COMP_CHAN = 3,
		MOUSE_BUTTONS_CHAN =4
	};

	enum {
		KEYBOARD_VOL,
		MOUSE_VOL,
		BUTTONS_VOL
	};
	
	void prep_synth(void);
	bool enabled;
	
	thread_id whistle_thread;
	port_id whistle_port;
	static int32 _run(void *arg);
	void run(void);
	
	BMidiSynth *synth;
	void set_vol(float value, int32 index);
	int32 vols[3];
	bool mutes[3];

	float pan_width, trans_width;
	int32 transposition;
	int32 notes[NOTE_COUNT];
	int32 chans[NOTE_COUNT];
	int32 button_num;
};


#endif /* WHISTLER */
